/**
 * Licensed to Big Data Genomics (BDG) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The BDG licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bdgenomics.utils.parquet.io

import com.amazonaws.auth.AWSCredentials
import com.amazonaws.services.s3.AmazonS3Client

class S3FileLocator(val credentials: AWSCredentials, val bucket: String, val key: String) extends FileLocator {

  override def parentLocator(): Option[FileLocator] = FileLocator.parseSlash(key) match {
    case Some((parent, child)) => Some(new S3FileLocator(credentials, bucket, parent))
    case None                  => None
  }

  override def relativeLocator(relativePath: String): FileLocator =
    new S3FileLocator(credentials, bucket, "%s/%s".format(key.stripSuffix("/"), relativePath))

  override def bytes: ByteAccess = new S3ByteAccess(new AmazonS3Client(credentials), bucket, key)
}
