/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.api.style;

import java.util.Objects;
import javax.annotation.Nonnull;

public class TreeStyle {
    private final String indent;
    private final String blankIndent;
    private final String junction;
    private final String lastJunction;
    private final String annotationStart;
    private final String annotationEnd;
    private final String calloutStart;
    private final String calloutEnd;

    public TreeStyle(String pIndent, String pJunction, String pLastJunction, String pAnnotationStart, String pAnnotationEnd, String pCalloutStart, String pCalloutEnd) {
        this.indent = Objects.requireNonNull(pIndent, "Argument pIndent must not be null");
        this.blankIndent = this.generateBlankIndent(pIndent);
        this.junction = Objects.requireNonNull(pJunction, "Argument pJunction must not be null");
        this.lastJunction = Objects.requireNonNull(pLastJunction, "Argument pLastJunction must not be null");
        this.annotationStart = Objects.requireNonNull(pAnnotationStart, "Argument pAnnotationStart must not be null");
        this.annotationEnd = Objects.requireNonNull(pAnnotationEnd, "Argument pAnnotation must not be null");
        this.calloutStart = Objects.requireNonNull(pCalloutStart, "Argument pCallout must not be null");
        this.calloutEnd = Objects.requireNonNull(pCalloutEnd, "Argument pCalloutEnd must not be null");
        if (pIndent.length() != pJunction.length() || pIndent.length() != pLastJunction.length()) {
            throw new IllegalArgumentException("element size mismatch");
        }
    }

    @Nonnull
    private String generateBlankIndent(@Nonnull String pIndent) {
        return pIndent.replaceAll(".", " ");
    }

    @Nonnull
    public String getIndent() {
        return this.indent;
    }

    @Nonnull
    public String getBlankIndent() {
        return this.blankIndent;
    }

    @Nonnull
    public String getJunction() {
        return this.junction;
    }

    @Nonnull
    public String getLastJunction() {
        return this.lastJunction;
    }

    @Nonnull
    public String getAnnotationStart() {
        return this.annotationStart;
    }

    @Nonnull
    public String getAnnotationEnd() {
        return this.annotationEnd;
    }

    @Nonnull
    public String getCalloutStart() {
        return this.calloutStart;
    }

    @Nonnull
    public String getCalloutEnd() {
        return this.calloutEnd;
    }
}

