/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.util.mongo;

import com.mongodb.MongoOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoOptionsFactory {
    private static final Logger logger = LoggerFactory.getLogger(MongoOptionsFactory.class);
    private MongoOptions defaults = new MongoOptions();
    private int connectionsPerHost;
    private int connectionTimeout;
    private int maxWaitTime;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private boolean autoConnectRetry;
    private int socketTimeOut;

    public MongoOptions createMongoOptions() {
        MongoOptions options = new MongoOptions();
        options.connectionsPerHost = this.getConnectionsPerHost();
        options.connectTimeout = this.getConnectionTimeout();
        options.maxWaitTime = this.getMaxWaitTime();
        options.threadsAllowedToBlockForConnectionMultiplier = this.getThreadsAllowedToBlockForConnectionMultiplier();
        options.autoConnectRetry = this.isAutoConnectRetry();
        options.socketTimeout = this.getSocketTimeOut();
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo Options");
            logger.debug("Connections per host :{}", (Object)options.connectionsPerHost);
            logger.debug("Connection timeout : {}", (Object)options.connectTimeout);
            logger.debug("Max wait timeout : {}", (Object)options.maxWaitTime);
            logger.debug("Threads allowed to block : {}", (Object)options.threadsAllowedToBlockForConnectionMultiplier);
            logger.debug("Autoconnect retry : {}", (Object)options.autoConnectRetry);
            logger.debug("Socket timeout : {}", (Object)options.socketTimeout);
        }
        return options;
    }

    public boolean isAutoConnectRetry() {
        return this.autoConnectRetry || this.defaults.autoConnectRetry;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost > 0 ? this.connectionsPerHost : this.defaults.connectionsPerHost;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout > 0 ? this.connectionTimeout : this.defaults.connectTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime > 0 ? this.maxWaitTime : this.defaults.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getSocketTimeOut() {
        return this.socketTimeOut > 0 ? this.socketTimeOut : this.defaults.socketTimeout;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier > 0 ? this.threadsAllowedToBlockForConnectionMultiplier : this.defaults.threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }
}

