/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.util.mongo;

import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.util.mongo.MongoInitializationException;

public class MongoFactory {
    private static final String SYSTEMPROPERTY_SINGLEINSTANCECONTEXT = "axon.mongo.singleinstance";
    private boolean singleInstanceContext;
    private List<ServerAddress> mongoAddresses;
    private MongoOptions mongoOptions;
    private WriteConcern writeConcern;

    public MongoFactory() {
        this(new ArrayList<ServerAddress>(), new MongoOptions(), WriteConcern.SAFE);
        this.singleInstanceContext = true;
    }

    public MongoFactory(List<ServerAddress> mongoAddresses) {
        this(mongoAddresses, new MongoOptions(), WriteConcern.REPLICAS_SAFE);
    }

    public MongoFactory(List<ServerAddress> mongoAddresses, MongoOptions mongoOptions, WriteConcern writeConcern) {
        this.mongoAddresses = mongoAddresses;
        this.mongoOptions = mongoOptions;
        this.writeConcern = writeConcern;
        this.singleInstanceContext = false;
    }

    public void setMongoAddresses(List<ServerAddress> mongoAddresses) {
        this.mongoAddresses = mongoAddresses;
    }

    public void setMongoOptions(MongoOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setSingleInstanceContext(boolean testContext) {
        this.singleInstanceContext = testContext;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public Mongo createMongoInstance() {
        Mongo mongo;
        if (this.isSingleInstanceContext()) {
            try {
                mongo = new Mongo(new ServerAddress(), this.mongoOptions);
            }
            catch (UnknownHostException e) {
                throw new MongoInitializationException("Could not create the default Mongo instance", e);
            }
        } else {
            if (this.mongoAddresses.isEmpty()) {
                throw new IllegalStateException("Please configure at least 1 instance of Mongo for production.");
            }
            mongo = new Mongo(this.mongoAddresses, this.mongoOptions);
        }
        mongo.setWriteConcern(this.determineWriteConcern());
        return mongo;
    }

    boolean isSingleInstanceContext() {
        String singleInstanceContext = System.getProperty(SYSTEMPROPERTY_SINGLEINSTANCECONTEXT);
        if (null != singleInstanceContext) {
            return Boolean.parseBoolean(singleInstanceContext);
        }
        return this.singleInstanceContext;
    }

    private WriteConcern determineWriteConcern() {
        WriteConcern toUseWriteConcern;
        if (this.isSingleInstanceContext()) {
            if (this.writeConcern != null) {
                if (this.writeConcern.getW() > WriteConcern.SAFE.getW()) {
                    throw new IllegalArgumentException("Invalid WriteConcern for a single instance Mongo context, can be maximum SAFE");
                }
                toUseWriteConcern = this.writeConcern;
            } else {
                toUseWriteConcern = WriteConcern.SAFE;
            }
        } else {
            toUseWriteConcern = this.writeConcern != null ? this.writeConcern : WriteConcern.REPLICAS_SAFE;
        }
        return toUseWriteConcern;
    }
}

