/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.io.Serializable;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.SagaStorageException;

public class AssociationValueEntry {
    static final String ASSOCIATION_KEY = "key";
    static final String ASSOCIATION_VALUE = "value";
    static final String ASSOCIATION_SAGA_IDENTIFIER = "sagaIdentifier";
    private String sagaId;
    private String associationKey;
    private String associationValue;

    public AssociationValueEntry(String sagaIdentifier, AssociationValue associationValue) {
        if (!Serializable.class.isInstance(associationValue.getValue())) {
            throw new SagaStorageException("Could not persist a saga association, since the value is not serializable");
        }
        this.sagaId = sagaIdentifier;
        this.associationKey = associationValue.getKey();
        this.associationValue = associationValue.getValue();
    }

    public AssociationValueEntry(DBObject dbObject) {
        this.sagaId = (String)dbObject.get(ASSOCIATION_SAGA_IDENTIFIER);
        this.associationKey = (String)dbObject.get(ASSOCIATION_KEY);
        this.associationValue = (String)dbObject.get(ASSOCIATION_VALUE);
    }

    public AssociationValue getAssociationValue() {
        return new AssociationValue(this.associationKey, this.associationValue);
    }

    public String getSagaIdentifier() {
        return this.sagaId;
    }

    public DBObject asDBObject() {
        return BasicDBObjectBuilder.start().add(ASSOCIATION_KEY, (Object)this.associationKey).add(ASSOCIATION_VALUE, (Object)this.associationValue).add(ASSOCIATION_SAGA_IDENTIFIER, (Object)this.sagaId).get();
    }

    public static DBObject queryByKeyAndValue(String key, String value) {
        return BasicDBObjectBuilder.start().add(ASSOCIATION_KEY, (Object)key).add(ASSOCIATION_VALUE, (Object)value).get();
    }

    public static DBObject queryBySagaIdentifier(String sagaIdentifier) {
        return BasicDBObjectBuilder.start().add(ASSOCIATION_SAGA_IDENTIFIER, (Object)sagaIdentifier).get();
    }

    public static DBObject queryBySagaIdentifierAndAssociationKeyValue(String sagaIdentifier, String key, String value) {
        return BasicDBObjectBuilder.start().add(ASSOCIATION_SAGA_IDENTIFIER, (Object)sagaIdentifier).add(ASSOCIATION_KEY, (Object)key).add(ASSOCIATION_VALUE, (Object)value).get();
    }
}

