/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventstore.EventStoreManagement;
import org.axonframework.eventstore.EventStreamNotFoundException;
import org.axonframework.eventstore.EventVisitor;
import org.axonframework.eventstore.SnapshotEventStore;
import org.axonframework.eventstore.XStreamEventSerializer;
import org.axonframework.eventstore.mongo.EventEntry;
import org.axonframework.eventstore.mongo.EventStoreCollections;
import org.axonframework.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoEventStore
implements SnapshotEventStore,
EventStoreManagement {
    private static final Logger logger = LoggerFactory.getLogger(MongoEventStore.class);
    private static final int EVENT_VISITOR_BATCH_SIZE = 50;
    private final EventStoreCollections eventStoreCollections;
    private final Serializer<? super DomainEvent> eventSerializer;

    public MongoEventStore(Serializer<? super DomainEvent> eventSerializer, EventStoreCollections mongo) {
        this.eventSerializer = eventSerializer;
        this.eventStoreCollections = mongo;
    }

    public MongoEventStore(EventStoreCollections mongo) {
        this((Serializer<? super DomainEvent>)new XStreamEventSerializer(), mongo);
    }

    @PostConstruct
    public void ensureIndexes() {
        this.eventStoreCollections.domainEventCollection().ensureIndex((DBObject)EventEntry.UNIQUE_INDEX, "uniqueAggregateIndex", true);
    }

    public void appendEvents(String type, DomainEventStream events) {
        ArrayList<DBObject> entries = new ArrayList<DBObject>();
        while (events.hasNext()) {
            DomainEvent event = events.next();
            EventEntry entry = new EventEntry(type, event, this.eventSerializer);
            entries.add(entry.asDBObject());
        }
        this.eventStoreCollections.domainEventCollection().insert(entries.toArray(new DBObject[entries.size()]));
        if (logger.isDebugEnabled()) {
            logger.debug("{} events of type {} appended", new Object[]{entries.size(), type});
        }
    }

    public DomainEventStream readEvents(String type, AggregateIdentifier identifier) {
        long snapshotSequenceNumber = -1L;
        EventEntry lastSnapshotEvent = this.loadLastSnapshotEvent(type, identifier);
        if (lastSnapshotEvent != null) {
            snapshotSequenceNumber = lastSnapshotEvent.getSequenceNumber();
        }
        List<DomainEvent> events = this.readEventSegmentInternal(type, identifier, snapshotSequenceNumber + 1L);
        if (lastSnapshotEvent != null) {
            events.add(0, lastSnapshotEvent.getDomainEvent(this.eventSerializer));
        }
        if (events.isEmpty()) {
            throw new EventStreamNotFoundException(type, identifier);
        }
        return new SimpleDomainEventStream(events);
    }

    public void appendSnapshotEvent(String type, DomainEvent snapshotEvent) {
        EventEntry snapshotEventEntry = new EventEntry(type, snapshotEvent, this.eventSerializer);
        this.eventStoreCollections.snapshotEventCollection().insert(new DBObject[]{snapshotEventEntry.asDBObject()});
        if (logger.isDebugEnabled()) {
            logger.debug("snapshot event of type {} appended.", (Object)type);
        }
    }

    public void visitEvents(EventVisitor visitor) {
        int first = 0;
        boolean shouldContinue = true;
        while (shouldContinue) {
            List<EventEntry> batch = this.fetchBatch(first, 50);
            for (EventEntry entry : batch) {
                visitor.doWithEvent(entry.getDomainEvent(this.eventSerializer));
            }
            shouldContinue = batch.size() >= 50;
            first += 50;
        }
    }

    private List<DomainEvent> readEventSegmentInternal(String type, AggregateIdentifier identifier, long firstSequenceNumber) {
        DBCursor dbCursor = this.eventStoreCollections.domainEventCollection().find(EventEntry.forAggregate(type, identifier.asString(), firstSequenceNumber)).sort((DBObject)new BasicDBObject("sequenceNumber", (Object)"1"));
        ArrayList<DomainEvent> events = new ArrayList<DomainEvent>(dbCursor.size());
        while (dbCursor.hasNext()) {
            String nextItem = (String)dbCursor.next().get("serializedEvent");
            DomainEvent deserialize = (DomainEvent)this.eventSerializer.deserialize(nextItem.getBytes(EventEntry.UTF8));
            events.add(deserialize);
        }
        return events;
    }

    private EventEntry loadLastSnapshotEvent(String type, AggregateIdentifier identifier) {
        DBObject mongoEntry = BasicDBObjectBuilder.start().add("aggregateIdentifier", (Object)identifier.asString()).add("type", (Object)type).get();
        DBCursor dbCursor = this.eventStoreCollections.snapshotEventCollection().find(mongoEntry).sort((DBObject)new BasicDBObject("sequenceNumber", (Object)-1)).limit(1);
        if (!dbCursor.hasNext()) {
            return null;
        }
        DBObject first = dbCursor.next();
        return new EventEntry(first);
    }

    private List<EventEntry> fetchBatch(int startPosition, int batchSize) {
        DBObject sort = BasicDBObjectBuilder.start().add("timeStamp", (Object)-1).add("sequenceNumber", (Object)-1).get();
        DBCursor batchDomainEvents = this.eventStoreCollections.domainEventCollection().find().sort(sort).limit(batchSize).skip(startPosition);
        ArrayList<EventEntry> entries = new ArrayList<EventEntry>();
        while (batchDomainEvents.hasNext()) {
            DBObject dbObject = batchDomainEvents.next();
            entries.add(new EventEntry(dbObject));
        }
        return entries;
    }
}

