/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.nio.charset.Charset;
import org.axonframework.domain.AggregateIdentifier;
import org.axonframework.domain.DomainEvent;
import org.axonframework.domain.StringAggregateIdentifier;
import org.axonframework.serializer.Serializer;

class EventEntry {
    public static final String AGGREGATE_IDENTIFIER_PROPERTY = "aggregateIdentifier";
    public static final String SEQUENCE_NUMBER_PROPERTY = "sequenceNumber";
    public static final String TIME_STAMP_PROPERTY = "timeStamp";
    public static final String AGGREGATE_TYPE_PROPERTY = "type";
    public static final String SERIALIZED_EVENT_PROPERTY = "serializedEvent";
    public static final BasicDBObject UNIQUE_INDEX = new BasicDBObject("aggregateIdentifier", (Object)1).append("type", (Object)1).append("sequenceNumber", (Object)1);
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    private final String aggregateIdentifier;
    private final long sequenceNumber;
    private final String timeStamp;
    private final String aggregateType;
    private final String serializedEvent;

    EventEntry(String aggregateType, DomainEvent event, Serializer<? super DomainEvent> eventSerializer) {
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = event.getAggregateIdentifier().asString();
        this.sequenceNumber = event.getSequenceNumber();
        this.serializedEvent = new String(eventSerializer.serialize((Object)event));
        this.timeStamp = event.getTimestamp().toString();
    }

    EventEntry(DBObject dbObject) {
        this.aggregateIdentifier = (String)dbObject.get(AGGREGATE_IDENTIFIER_PROPERTY);
        this.sequenceNumber = (Long)dbObject.get(SEQUENCE_NUMBER_PROPERTY);
        this.serializedEvent = (String)dbObject.get(SERIALIZED_EVENT_PROPERTY);
        this.timeStamp = (String)dbObject.get(TIME_STAMP_PROPERTY);
        this.aggregateType = (String)dbObject.get(AGGREGATE_TYPE_PROPERTY);
    }

    public DomainEvent getDomainEvent(Serializer<? super DomainEvent> eventSerializer) {
        return (DomainEvent)eventSerializer.deserialize(this.serializedEvent.getBytes(UTF8));
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public AggregateIdentifier getAggregateIdentifier() {
        return new StringAggregateIdentifier(this.aggregateIdentifier);
    }

    public DBObject asDBObject() {
        return BasicDBObjectBuilder.start().add(AGGREGATE_IDENTIFIER_PROPERTY, (Object)this.aggregateIdentifier).add(SEQUENCE_NUMBER_PROPERTY, (Object)this.sequenceNumber).add(SERIALIZED_EVENT_PROPERTY, (Object)this.serializedEvent).add(TIME_STAMP_PROPERTY, (Object)this.timeStamp).add(AGGREGATE_TYPE_PROPERTY, (Object)this.aggregateType).get();
    }

    public static DBObject forAggregate(String type, String aggregateIdentifier, long firstSequenceNumber) {
        return BasicDBObjectBuilder.start().add(AGGREGATE_IDENTIFIER_PROPERTY, (Object)aggregateIdentifier).add(SEQUENCE_NUMBER_PROPERTY, (Object)new BasicDBObject("$gte", (Object)firstSequenceNumber)).add(AGGREGATE_TYPE_PROPERTY, (Object)type).get();
    }
}

