/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import org.axonframework.saga.Saga;
import org.axonframework.saga.repository.SagaSerializer;

public class SagaEntry {
    static final String SAGA_IDENTIFIER = "sagaIdentifier";
    static final String SERIALIZED_SAGA = "serializedSaga";
    private String sagaId;
    private byte[] serializedSaga;

    public SagaEntry(Saga saga, SagaSerializer serializer) {
        this.sagaId = saga.getSagaIdentifier();
        this.serializedSaga = serializer.serialize(saga);
    }

    public SagaEntry(DBObject dbSaga) {
        this.sagaId = (String)dbSaga.get(SAGA_IDENTIFIER);
        this.serializedSaga = (byte[])dbSaga.get(SERIALIZED_SAGA);
    }

    public Saga getSaga(SagaSerializer serializer) {
        return serializer.deserialize(this.serializedSaga);
    }

    public String getSagaId() {
        return this.sagaId;
    }

    public DBObject asDBObject() {
        return BasicDBObjectBuilder.start().add(SAGA_IDENTIFIER, (Object)this.sagaId).add(SERIALIZED_SAGA, (Object)this.serializedSaga).get();
    }

    public static DBObject queryByIdentifier(String identifier) {
        return BasicDBObjectBuilder.start().add(SAGA_IDENTIFIER, (Object)identifier).get();
    }
}

