/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.mongo;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Set;
import javax.annotation.Resource;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.NoSuchSagaException;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.Saga;
import org.axonframework.saga.repository.AbstractSagaRepository;
import org.axonframework.saga.repository.JavaSagaSerializer;
import org.axonframework.saga.repository.SagaSerializer;
import org.axonframework.saga.repository.mongo.AssociationValueEntry;
import org.axonframework.saga.repository.mongo.MongoTemplate;
import org.axonframework.saga.repository.mongo.SagaEntry;

public class MongoSagaRepository
extends AbstractSagaRepository {
    private MongoTemplate mongoTemplate;
    private SagaSerializer serializer;
    private ResourceInjector injector;
    private volatile boolean initialized = false;

    public MongoSagaRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        this.serializer = new JavaSagaSerializer();
    }

    public <T extends Saga> Set<T> find(Class<T> type, Set<AssociationValue> associationValues) {
        if (!this.initialized) {
            this.initialize();
        }
        return super.find(type, associationValues);
    }

    public void add(Saga saga) {
        if (!this.initialized) {
            this.initialize();
        }
        super.add(saga);
    }

    public void commit(Saga saga) {
        if (!this.initialized) {
            this.initialize();
        }
        super.commit(saga);
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            DBCursor dbCursor = this.mongoTemplate.associationsCollection().find();
            this.getAssociationValueMap().clear();
            while (dbCursor.hasNext()) {
                AssociationValueEntry entry = new AssociationValueEntry(dbCursor.next());
                this.getAssociationValueMap().add(entry.getAssociationValue(), entry.getSagaIdentifier());
            }
            this.initialized = true;
        }
    }

    protected void deleteSaga(Saga saga) {
        this.mongoTemplate.sagaCollection().findAndRemove(SagaEntry.queryByIdentifier(saga.getSagaIdentifier()));
    }

    protected <T extends Saga> T loadSaga(Class<T> type, String sagaIdentifier) {
        DBObject dbSaga = this.mongoTemplate.sagaCollection().findOne(SagaEntry.queryByIdentifier(sagaIdentifier));
        if (dbSaga == null) {
            throw new NoSuchSagaException(type, sagaIdentifier);
        }
        SagaEntry sagaEntry = new SagaEntry(dbSaga);
        Saga loadedSaga = sagaEntry.getSaga(this.serializer);
        if (!type.isInstance(loadedSaga)) {
            return null;
        }
        Saga storedSaga = (Saga)type.cast(loadedSaga);
        if (this.injector != null) {
            this.injector.injectResources(storedSaga);
        }
        return (T)storedSaga;
    }

    protected void updateSaga(Saga saga) {
        SagaEntry sagaEntry = new SagaEntry(saga, this.serializer);
        this.mongoTemplate.sagaCollection().findAndModify(SagaEntry.queryByIdentifier(saga.getSagaIdentifier()), sagaEntry.asDBObject());
    }

    protected void storeSaga(Saga saga) {
        SagaEntry sagaEntry = new SagaEntry(saga, this.serializer);
        this.mongoTemplate.sagaCollection().save(sagaEntry.asDBObject());
    }

    protected void storeAssociationValue(AssociationValue associationValue, String sagaIdentifier) {
        AssociationValueEntry associationValueEntry = new AssociationValueEntry(sagaIdentifier, associationValue);
        this.mongoTemplate.associationsCollection().save(associationValueEntry.asDBObject());
    }

    protected void removeAssociationValue(AssociationValue associationValue, String sagaIdentifier) {
        DBObject query = AssociationValueEntry.queryBySagaIdentifierAndAssociationKeyValue(sagaIdentifier, associationValue.getKey(), associationValue.getValue());
        this.mongoTemplate.associationsCollection().findAndRemove(query);
    }

    public void setSerializer(SagaSerializer serializer) {
        this.serializer = serializer;
    }

    @Resource
    public void setResourceInjector(ResourceInjector resourceInjector) {
        this.injector = resourceInjector;
    }
}

