/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.serialization;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.nio.charset.Charset;
import org.axonframework.extensions.mongo.serialization.DBObjectHierarchicalStreamReader;
import org.axonframework.extensions.mongo.serialization.DBObjectHierarchicalStreamWriter;
import org.axonframework.extensions.mongo.serialization.DBObjectToStringContentTypeConverter;
import org.axonframework.extensions.mongo.serialization.DocumentToStringContentTypeConverter;
import org.axonframework.extensions.mongo.serialization.StringToDBObjectContentTypeConverter;
import org.axonframework.serialization.AbstractXStreamSerializer;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;

public class DBObjectXStreamSerializer
extends AbstractXStreamSerializer {
    protected DBObjectXStreamSerializer(Builder builder) {
        super((AbstractXStreamSerializer.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void registerConverters(ChainingConverter converter) {
        converter.registerConverter((ContentTypeConverter)new DBObjectToStringContentTypeConverter());
        converter.registerConverter((ContentTypeConverter)new DocumentToStringContentTypeConverter());
        converter.registerConverter((ContentTypeConverter)new StringToDBObjectContentTypeConverter());
    }

    protected <T> T doSerialize(Object object, Class<T> expectedFormat, XStream xStream) {
        BasicDBObject root = new BasicDBObject();
        this.getXStream().marshal(object, (HierarchicalStreamWriter)new DBObjectHierarchicalStreamWriter((DBObject)root));
        return (T)this.convert(root, DBObject.class, expectedFormat);
    }

    protected Object doDeserialize(SerializedObject serializedObject, XStream xStream) {
        DBObject serialized = (DBObject)this.convert(serializedObject.getData(), serializedObject.getContentType(), DBObject.class);
        return this.getXStream().unmarshal((HierarchicalStreamReader)new DBObjectHierarchicalStreamReader(serialized));
    }

    public static class Builder
    extends AbstractXStreamSerializer.Builder {
        private Builder() {
            this.xStream(new XStream());
        }

        public Builder xStream(XStream xStream) {
            super.xStream(xStream);
            return this;
        }

        public Builder charset(Charset charset) {
            super.charset(charset);
            return this;
        }

        public Builder revisionResolver(RevisionResolver revisionResolver) {
            super.revisionResolver(revisionResolver);
            return this;
        }

        public Builder converter(Converter converter) {
            super.converter(converter);
            return this;
        }

        public DBObjectXStreamSerializer build() {
            return new DBObjectXStreamSerializer(this);
        }
    }
}

