/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.serialization;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;

public class BSONNode {
    private static final String ATTRIBUTE_PREFIX = "attr_";
    private static final String VALUE_KEY = "_value";
    private final List<BSONNode> childNodes = new ArrayList<BSONNode>();
    private String value;
    private final String encodedName;

    public BSONNode(String name) {
        this.encodedName = BSONNode.encode(name);
    }

    public static BSONNode fromDBObject(DBObject node) {
        if (node.keySet().size() != 1) {
            throw new IllegalArgumentException("Given node should have exactly one attribute");
        }
        String rootName = (String)node.keySet().iterator().next();
        BSONNode rootNode = new BSONNode(BSONNode.decode(rootName));
        Object rootContents = node.get(rootName);
        if (rootContents instanceof List) {
            ((List)rootContents).stream().filter(childElement -> childElement instanceof DBObject).forEach(childElement -> {
                DBObject dbChild = (DBObject)childElement;
                if (dbChild.containsField(VALUE_KEY)) {
                    rootNode.setValue((String)dbChild.get(VALUE_KEY));
                } else {
                    rootNode.addChildNode(BSONNode.fromDBObject(dbChild));
                }
            });
        } else if (rootContents instanceof DBObject) {
            rootNode.addChildNode(BSONNode.fromDBObject((DBObject)rootContents));
        } else if (rootContents instanceof String) {
            rootNode.setValue((String)rootContents);
        } else {
            throw new IllegalArgumentException("Node in " + rootName + " contains child " + rootContents + " which cannot be parsed");
        }
        return rootNode;
    }

    private void addChildNode(BSONNode bsonNode) {
        this.childNodes.add(bsonNode);
    }

    public DBObject asDBObject() {
        if (this.childNodes.isEmpty() && this.value != null) {
            return new BasicDBObject(this.encodedName, (Object)this.value);
        }
        if (this.childNodes.size() == 1 && this.value == null) {
            return new BasicDBObject(this.encodedName, (Object)this.childNodes.get(0).asDBObject());
        }
        BasicDBList subNodes = new BasicDBList();
        BasicDBObject thisNode = new BasicDBObject(this.encodedName, (Object)subNodes);
        if (this.value != null) {
            subNodes.add((Object)new BasicDBObject(VALUE_KEY, (Object)this.value));
        }
        subNodes.addAll((Collection)this.childNodes.stream().map(BSONNode::asDBObject).collect(Collectors.toList()));
        return thisNode;
    }

    public void setValue(String value) {
        Assert.isFalse((boolean)this.children().hasNext(), () -> "A child node was already present. A node cannot contain a value as well as child nodes.");
        this.value = value;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.addChild(ATTRIBUTE_PREFIX + attributeName, attributeValue);
    }

    public BSONNode addChildNode(String name) {
        Assert.isTrue((this.value == null ? 1 : 0) != 0, () -> "A value was already present.A node cannot contain a value as well as child nodes");
        Assert.notNull((Object)name, () -> "Node name must not be null");
        Assert.isFalse((boolean)name.startsWith(ATTRIBUTE_PREFIX), () -> "Node names may not start with 'attr_'");
        return this.addChild(name, null);
    }

    private BSONNode addChild(String name, String nodeValue) {
        BSONNode childNode = new BSONNode(name);
        childNode.setValue(nodeValue);
        this.childNodes.add(childNode);
        return childNode;
    }

    public Iterator<BSONNode> children() {
        List children = this.childNodes.stream().filter(child -> !child.encodedName.startsWith(ATTRIBUTE_PREFIX)).collect(Collectors.toList());
        return children.iterator();
    }

    public Map<String, String> attributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        this.childNodes.stream().filter(child -> !VALUE_KEY.equals(child.encodedName) && child.encodedName.startsWith(ATTRIBUTE_PREFIX)).forEach(child -> attrs.put(child.encodedName, child.value));
        return attrs;
    }

    public String getAttribute(String name) {
        String attr = ATTRIBUTE_PREFIX + name;
        return this.getChildValue(attr);
    }

    private String getChildValue(String name) {
        for (BSONNode node : this.childNodes) {
            if (!name.equals(node.encodedName)) continue;
            return node.value;
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return BSONNode.decode(this.encodedName);
    }

    private static String encode(String name) {
        return name.replaceAll("\\/", "\\/\\/").replaceAll("\\.", "/");
    }

    private static String decode(String name) {
        return name.replaceAll("\\/([^/]])?", ".$1").replaceAll("\\/\\/", "/");
    }
}

