/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.Collections;
import java.util.List;

public class MongoFactory {
    private List<ServerAddress> mongoAddresses = Collections.emptyList();
    private MongoClientOptions mongoOptions = MongoClientOptions.builder().build();
    private WriteConcern writeConcern;

    public MongoClient createMongo() {
        MongoClient mongo = this.mongoAddresses.isEmpty() ? new MongoClient(new ServerAddress(), this.mongoOptions) : new MongoClient(this.mongoAddresses, this.mongoOptions);
        mongo.setWriteConcern(this.defaultWriteConcern());
        return mongo;
    }

    public void setMongoAddresses(List<ServerAddress> mongoAddresses) {
        this.mongoAddresses = mongoAddresses;
    }

    public void setMongoOptions(MongoClientOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    private WriteConcern defaultWriteConcern() {
        if (this.writeConcern != null) {
            return this.writeConcern;
        }
        if (this.mongoAddresses.size() > 1) {
            return WriteConcern.REPLICAS_SAFE;
        }
        return WriteConcern.FSYNC_SAFE;
    }
}

