/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.serialization;

import com.mongodb.DBObject;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.axonframework.common.Assert;
import org.axonframework.extensions.mongo.serialization.BSONNode;
import org.bson.BSONObject;

public class DBObjectHierarchicalStreamWriter
implements ExtendedHierarchicalStreamWriter {
    private final Deque<BSONNode> itemStack = new ArrayDeque<BSONNode>();
    private final DBObject root;

    public DBObjectHierarchicalStreamWriter(DBObject root) {
        Assert.isTrue((boolean)root.keySet().isEmpty(), () -> "The given root object must be empty.");
        this.root = root;
    }

    public void startNode(String name) {
        if (this.itemStack.isEmpty()) {
            this.itemStack.push(new BSONNode(name));
        } else {
            this.itemStack.push(this.itemStack.peek().addChildNode(name));
        }
    }

    public void addAttribute(String name, String value) {
        this.itemStack.peek().setAttribute(name, value);
    }

    public void setValue(String text) {
        this.itemStack.peek().setValue(text);
    }

    public void endNode() {
        BSONNode closingElement = this.itemStack.pop();
        if (this.itemStack.isEmpty()) {
            this.root.putAll((BSONObject)closingElement.asDBObject());
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    public void startNode(String name, Class clazz) {
        this.startNode(name);
    }
}

