/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.TrackingToken;

public class MongoTrackingToken
implements TrackingToken,
Serializable {
    private final long timestamp;
    private final Map<String, Long> trackedEvents;

    private MongoTrackingToken(long timestamp, Map<String, Long> trackedEvents) {
        this.timestamp = timestamp;
        this.trackedEvents = trackedEvents;
    }

    public static MongoTrackingToken of(Instant timestamp, String eventIdentifier) {
        return new MongoTrackingToken(timestamp.toEpochMilli(), Collections.singletonMap(eventIdentifier, timestamp.toEpochMilli()));
    }

    @JsonCreator
    public static MongoTrackingToken of(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="trackedEvents") Map<String, Long> trackedEvents) {
        return new MongoTrackingToken(timestamp.toEpochMilli(), trackedEvents);
    }

    public MongoTrackingToken advanceTo(Instant timestamp, String eventIdentifier, Duration lookBackTime) {
        if (this.trackedEvents.containsKey(eventIdentifier)) {
            throw new IllegalArgumentException(String.format("The event to advance to [%s] should not be one of the token's known events", eventIdentifier));
        }
        long millis = timestamp.toEpochMilli();
        LinkedHashMap<String, Long> trackedEvents = new LinkedHashMap<String, Long>(this.trackedEvents);
        trackedEvents.put(eventIdentifier, millis);
        long newTimestamp = Math.max(millis, this.timestamp);
        return new MongoTrackingToken(newTimestamp, this.trim(trackedEvents, newTimestamp, lookBackTime));
    }

    private Map<String, Long> trim(LinkedHashMap<String, Long> priorEvents, long currentTime, Duration lookBackTime) {
        Long cutOffTimestamp = currentTime - lookBackTime.toMillis();
        Iterator<Long> iterator = priorEvents.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().compareTo(cutOffTimestamp) < 0) {
                iterator.remove();
                continue;
            }
            return priorEvents;
        }
        return priorEvents;
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    public Map<String, Long> getTrackedEvents() {
        return Collections.unmodifiableMap(this.trackedEvents);
    }

    @JsonIgnore
    public Set<String> getKnownEventIds() {
        return Collections.unmodifiableSet(this.trackedEvents.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoTrackingToken that = (MongoTrackingToken)o;
        return this.timestamp == that.timestamp && Objects.equals(this.trackedEvents, that.trackedEvents);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.trackedEvents);
    }

    public String toString() {
        return "MongoTrackingToken{timestamp=" + this.timestamp + ", trackedEvents=" + this.trackedEvents + '}';
    }

    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof MongoTrackingToken), () -> "Incompatible token type provided.");
        MongoTrackingToken otherToken = (MongoTrackingToken)other;
        HashMap<String, Long> intersection = new HashMap<String, Long>(this.trackedEvents);
        this.trackedEvents.keySet().forEach(k -> {
            if (!otherToken.trackedEvents.containsKey(k)) {
                intersection.remove(k);
            }
        });
        return new MongoTrackingToken(Math.min(this.timestamp, otherToken.timestamp), intersection);
    }

    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof MongoTrackingToken), () -> "Incompatible token type provided.");
        Long timestamp = Math.max(((MongoTrackingToken)other).timestamp, this.timestamp);
        HashMap<String, Long> events = new HashMap<String, Long>(this.trackedEvents);
        events.putAll(((MongoTrackingToken)other).trackedEvents);
        return new MongoTrackingToken(timestamp, events);
    }

    public boolean covers(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof MongoTrackingToken), () -> "Incompatible token type provided.");
        MongoTrackingToken otherToken = (MongoTrackingToken)other;
        long oldest = this.trackedEvents.values().stream().min(Comparator.naturalOrder()).orElse(0L);
        return otherToken.timestamp <= this.timestamp && otherToken.trackedEvents.keySet().stream().allMatch(k -> this.trackedEvents.containsKey(k) || otherToken.trackedEvents.get(k) < oldest);
    }
}

