/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore;

import com.mongodb.MongoClientOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoOptionsFactory {
    private static final Logger logger = LoggerFactory.getLogger(MongoOptionsFactory.class);
    private final MongoClientOptions defaults = MongoClientOptions.builder().build();
    private int connectionsPerHost;
    private int connectionTimeout;
    private int maxWaitTime;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private int socketTimeOut;

    public MongoClientOptions createMongoOptions() {
        MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost(this.getConnectionsPerHost()).connectTimeout(this.getConnectionTimeout()).maxWaitTime(this.getMaxWaitTime()).threadsAllowedToBlockForConnectionMultiplier(this.getThreadsAllowedToBlockForConnectionMultiplier()).socketTimeout(this.getSocketTimeOut()).build();
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo Options");
            logger.debug("Connections per host :{}", (Object)options.getConnectionsPerHost());
            logger.debug("Connection timeout : {}", (Object)options.getConnectTimeout());
            logger.debug("Max wait timeout : {}", (Object)options.getMaxWaitTime());
            logger.debug("Threads allowed to block : {}", (Object)options.getThreadsAllowedToBlockForConnectionMultiplier());
            logger.debug("Socket timeout : {}", (Object)options.getSocketTimeout());
        }
        return options;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost > 0 ? this.connectionsPerHost : this.defaults.getConnectionsPerHost();
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout > 0 ? this.connectionTimeout : this.defaults.getConnectTimeout();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime > 0 ? this.maxWaitTime : this.defaults.getMaxWaitTime();
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getSocketTimeOut() {
        return this.socketTimeOut > 0 ? this.socketTimeOut : this.defaults.getSocketTimeout();
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier > 0 ? this.threadsAllowedToBlockForConnectionMultiplier : this.defaults.getThreadsAllowedToBlockForConnectionMultiplier();
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }
}

