/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;

public abstract class AbstractMongoTemplate {
    private final MongoDatabase database;

    protected AbstractMongoTemplate(Builder builder) {
        builder.validate();
        this.database = builder.database;
    }

    protected MongoDatabase database() {
        return this.database;
    }

    public static abstract class Builder {
        private static final String DEFAULT_AXONFRAMEWORK_DATABASE = "axonframework";
        private MongoDatabase database;

        public Builder mongoDatabase(MongoClient mongoClient) {
            return this.mongoDatabase(mongoClient, DEFAULT_AXONFRAMEWORK_DATABASE);
        }

        public Builder mongoDatabase(MongoClient mongoClient, String databaseName) {
            BuilderUtils.assertNonNull((Object)mongoClient, (String)"MongoClient may not be null");
            this.database = mongoClient.getDatabase(databaseName);
            return this;
        }

        public Builder mongoDatabase(MongoDatabase mongoDatabase) {
            BuilderUtils.assertNonNull((Object)mongoDatabase, (String)"MongoDatabase may not be null");
            this.database = mongoDatabase;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.database, (String)"The MongoDatabase is a hard requirement and should be provided");
        }
    }
}

