/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.amqp.eventhandling.spring;

import com.rabbitmq.client.Channel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.extensions.amqp.eventhandling.DefaultAMQPMessageConverter;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.serialization.Serializer;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;

public class SpringAMQPMessageSource
implements ChannelAwareMessageListener,
SubscribableMessageSource<EventMessage<?>> {
    private final List<Consumer<List<? extends EventMessage<?>>>> eventProcessors = new CopyOnWriteArrayList();
    private final AMQPMessageConverter messageConverter;

    public SpringAMQPMessageSource(Serializer serializer) {
        this(DefaultAMQPMessageConverter.builder().serializer(serializer).build());
    }

    public SpringAMQPMessageSource(AMQPMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public Registration subscribe(Consumer<List<? extends EventMessage<?>>> messageProcessor) {
        this.eventProcessors.add(messageProcessor);
        return () -> this.eventProcessors.remove(messageProcessor);
    }

    public void onMessage(Message message, Channel channel) {
        if (!this.eventProcessors.isEmpty()) {
            this.messageConverter.readAMQPMessage(message.getBody(), message.getMessageProperties().getHeaders()).ifPresent(event -> this.eventProcessors.forEach(ep -> ep.accept(Collections.singletonList(event))));
        }
    }
}

