/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.amqp.eventhandling.legacy;

import com.rabbitmq.client.AMQP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.axonframework.amqp.eventhandling.AMQPMessage;
import org.axonframework.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.amqp.eventhandling.PackageRoutingKeyResolver;
import org.axonframework.amqp.eventhandling.RoutingKeyResolver;
import org.axonframework.amqp.eventhandling.legacy.EventMessageReader;
import org.axonframework.amqp.eventhandling.legacy.EventMessageWriter;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.EventPublicationFailedException;
import org.axonframework.serialization.Serializer;

public class JavaSerializationAMQPMessageConverter
implements AMQPMessageConverter {
    private static final AMQP.BasicProperties DURABLE = new AMQP.BasicProperties.Builder().deliveryMode(Integer.valueOf(2)).build();
    private final Serializer serializer;
    private final RoutingKeyResolver routingKeyResolver;
    private final boolean durable;

    public JavaSerializationAMQPMessageConverter(Serializer serializer) {
        this(serializer, new PackageRoutingKeyResolver(), true);
    }

    public JavaSerializationAMQPMessageConverter(Serializer serializer, RoutingKeyResolver routingKeyResolver, boolean durable) {
        Assert.notNull((Object)serializer, () -> "Serializer may not be null");
        Assert.notNull((Object)routingKeyResolver, () -> "RoutingKeyResolver may not be null");
        this.serializer = serializer;
        this.routingKeyResolver = routingKeyResolver;
        this.durable = durable;
    }

    public AMQPMessage createAMQPMessage(EventMessage eventMessage) {
        byte[] body = this.asByteArray(eventMessage);
        String routingKey = this.routingKeyResolver.resolveRoutingKey(eventMessage);
        if (this.durable) {
            return new AMQPMessage(body, routingKey, DURABLE, false, false);
        }
        return new AMQPMessage(body, routingKey);
    }

    @Override
    public Optional<EventMessage<?>> readAMQPMessage(byte[] messageBody, Map<String, Object> headers) {
        try {
            EventMessageReader in = new EventMessageReader(new DataInputStream(new ByteArrayInputStream(messageBody)), this.serializer);
            return Optional.of(in.readEventMessage());
        }
        catch (IOException e) {
            throw new EventPublicationFailedException("Failed to deserialize an EventMessage", (Throwable)e);
        }
    }

    private byte[] asByteArray(EventMessage event) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            EventMessageWriter outputStream = new EventMessageWriter(new DataOutputStream(baos), this.serializer);
            outputStream.writeEventMessage(event);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EventPublicationFailedException("Failed to serialize an EventMessage", (Throwable)e);
        }
    }
}

