/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi.transaction;

import java.lang.invoke.MethodHandles;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.axonframework.common.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransaction
implements Transaction {
    private static final String USER_TRANSACTION_LOCATION = "java:comp/UserTransaction";
    private static final String JBOSS_USER_TRANSACTION_LOCATION = "java:jboss/UserTransaction";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOCATION = "java:comp/TransactionSynchronizationRegistry";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private UserTransaction userTransaction = null;
    private TransactionSynchronizationRegistry registry;
    private boolean owned = true;

    public JtaTransaction() {
        this.detectContext();
        this.attemptBegin();
    }

    public void commit() {
        this.attemptCommit();
    }

    public void rollback() {
        this.attemptRollback();
    }

    private void detectContext() {
        this.userTransaction = this.getUserTransaction();
        if (this.userTransaction != null) {
            logger.debug("In a BMT compatible context, using UserTransaction.");
            try {
                int status = this.userTransaction.getStatus();
                if (status == 4 || status == 1) {
                    logger.error("Cleanup of transaction that has been rolled back previously.");
                    this.userTransaction.rollback();
                    status = this.userTransaction.getStatus();
                }
                if (status != 6) {
                    logger.debug("We cannot own the BMT transaction, the current transaction status is {}.", (Object)this.statusToString(status));
                    this.owned = false;
                }
            }
            catch (SystemException ex) {
                logger.warn("Had trouble trying to get BMT transaction status.", (Throwable)ex);
                this.owned = false;
            }
        } else {
            this.registry = this.getTransactionSynchronizationRegistry();
            if (this.registry != null) {
                logger.debug("Most likely in a CMT compatible context, using TransactionSynchronizationRegistry.");
            } else {
                logger.warn("No JTA APIs available in this context. No transation managment can be performed.");
            }
        }
    }

    private void attemptBegin() {
        block7: {
            logger.debug("Beginning JTA transaction if required and possible.");
            if (this.userTransaction != null) {
                try {
                    if (this.owned) {
                        logger.debug("Beginning BMT transaction.");
                        this.userTransaction.begin();
                        break block7;
                    }
                    logger.debug("Did not try to begin non-owned BMT transaction.");
                }
                catch (NotSupportedException | SystemException ex) {
                    logger.warn("Had trouble trying to start BMT transaction.", ex);
                }
            } else if (this.registry != null) {
                logger.debug("Not allowed to begin CMT transaction, the current transaction status is {}.", (Object)this.statusToString(this.registry.getTransactionStatus()));
            } else {
                logger.warn("No JTA APIs available in this context. No begin done.");
            }
        }
    }

    private void attemptCommit() {
        block9: {
            logger.debug("Committing JTA transaction if required and possible.");
            if (this.userTransaction != null) {
                try {
                    if (this.owned) {
                        if (this.userTransaction.getStatus() == 0) {
                            logger.debug("Committing BMT transaction.");
                            this.userTransaction.commit();
                        } else {
                            logger.warn("Cannot commit BMT transaction, current transaction status is {}.", (Object)this.statusToString(this.userTransaction.getStatus()));
                        }
                        break block9;
                    }
                    logger.debug("Cannot commit non-owned BMT transaction.");
                }
                catch (IllegalStateException | SecurityException | HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException ex) {
                    logger.warn("Had trouble trying to commit BMT transaction.", ex);
                }
            } else if (this.registry != null) {
                logger.debug("Not allowed to commit CMT transaction, the current transaction status is {}.", (Object)this.statusToString(this.registry.getTransactionStatus()));
            } else {
                logger.warn("No JTA APIs available in this context. No commit done.");
            }
        }
    }

    private void attemptRollback() {
        block11: {
            logger.debug("Rolling back JTA transaction if required and possible.");
            if (this.userTransaction != null) {
                try {
                    if (this.userTransaction.getStatus() == 0) {
                        if (this.owned) {
                            logger.debug("Rolling back BMT transaction.");
                            this.userTransaction.rollback();
                        } else {
                            logger.debug("Setting rollback for non-owned BMT transaction.");
                            this.userTransaction.setRollbackOnly();
                        }
                        break block11;
                    }
                    logger.warn("Cannot roll back BMT transaction, current transaction status is {}.", (Object)this.statusToString(this.userTransaction.getStatus()));
                }
                catch (IllegalStateException | SecurityException | SystemException ex) {
                    logger.warn("Had trouble trying to roll back BMT transaction.", ex);
                }
            } else if (this.registry != null) {
                if (this.registry.getTransactionStatus() == 0) {
                    logger.debug("Setting CMT transaction to roll back.");
                    this.registry.setRollbackOnly();
                } else {
                    logger.warn("Cannot roll back CMT transaction, current transaction status is {}.", (Object)this.statusToString(this.registry.getTransactionStatus()));
                }
            } else {
                logger.warn("No JTA APIs available in this context. No rollback performed.");
            }
        }
    }

    private UserTransaction getUserTransaction() {
        try {
            logger.debug("Attempting to look up standard UserTransaction.");
            return (UserTransaction)new InitialContext().lookup(USER_TRANSACTION_LOCATION);
        }
        catch (NamingException ex) {
            logger.debug("Could not look up standard UserTransaction.", (Throwable)ex);
            try {
                logger.debug("Attempting to look up JBoss proprietary UserTransaction.");
                return (UserTransaction)new InitialContext().lookup(JBOSS_USER_TRANSACTION_LOCATION);
            }
            catch (NamingException ex1) {
                logger.debug("Could not look up JBoss proprietary UserTransaction.", (Throwable)ex1);
                return null;
            }
        }
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        try {
            return (TransactionSynchronizationRegistry)new InitialContext().lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOCATION);
        }
        catch (NamingException ex) {
            logger.debug("Could not look up TransactionSynchronizationRegistry.", (Throwable)ex);
            return null;
        }
    }

    private String statusToString(int status) {
        switch (status) {
            case 0: {
                return "Active";
            }
            case 3: {
                return "Committed";
            }
            case 8: {
                return "Commiting";
            }
            case 1: {
                return "Marked for rollback";
            }
            case 6: {
                return "No transaction";
            }
            case 2: {
                return "Prepared";
            }
            case 7: {
                return "Preparing";
            }
            case 4: {
                return "Rolled back";
            }
            case 9: {
                return "Rolling back";
            }
            case 5: {
                return "Unknown";
            }
        }
        return null;
    }
}

