/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi;

import java.util.Optional;
import org.axonframework.cdi.StringUtilities;
import org.axonframework.cdi.stereotype.Saga;

class SagaDefinition {
    private final Class<?> sagaType;

    SagaDefinition(Class<?> sagaType) {
        this.sagaType = sagaType;
    }

    Class<?> sagaType() {
        return this.sagaType;
    }

    Optional<String> sagaStore() {
        return StringUtilities.createOptional(this.getSagaAnnotation().sagaStore());
    }

    Optional<String> configurationBean() {
        return StringUtilities.createOptional(this.getSagaAnnotation().configurationBean());
    }

    boolean explicitConfiguration() {
        return this.configurationBean().isPresent();
    }

    String configurationName() {
        return this.configurationBean().orElse(StringUtilities.lowerCaseFirstLetter(this.sagaType().getSimpleName()) + "Configuration");
    }

    private Saga getSagaAnnotation() {
        return this.sagaType.getAnnotation(Saga.class);
    }
}

