/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.axonframework.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWrapper<T>
implements Bean<T>,
PassivationCapable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final Class<T> clazz;
    private final Supplier<T> supplier;

    public BeanWrapper(Class<T> clazz, Supplier<T> supplier) {
        this(clazz.getSimpleName(), clazz, supplier);
    }

    public BeanWrapper(String name, Class<T> clazz, Supplier<T> supplier) {
        this.name = name;
        this.clazz = clazz;
        this.supplier = supplier;
    }

    public T create(CreationalContext<T> context) {
        return this.supplier.get();
    }

    public void destroy(T instance, CreationalContext<T> context) {
        if (this.clazz.equals(Configuration.class)) {
            logger.info("Shutting down Axon configuration.");
            ((Configuration)instance).shutdown();
        }
        instance = null;
        context.release();
    }

    public String getName() {
        return this.name;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this.clazz);
        types.add((Type)((Object)Object.class));
        return types;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public String getId() {
        return this.clazz.toString() + "#" + this.supplier.toString();
    }
}

