/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.cdi.StringUtilities;
import org.axonframework.cdi.stereotype.Aggregate;

class AggregateDefinition {
    private final Class<?> aggregateType;

    AggregateDefinition(Class<?> aggregateType) {
        this.aggregateType = aggregateType;
    }

    Class<?> aggregateType() {
        return this.aggregateType;
    }

    Optional<String> repository() {
        return StringUtilities.createOptional(this.getAggregateAnnotation().repository());
    }

    String repositoryName() {
        return this.repository().orElse(StringUtilities.lowerCaseFirstLetter(this.aggregateType().getSimpleName()) + "Repository");
    }

    Optional<String> snapshotTriggerDefinition() {
        return StringUtilities.createOptional(this.getAggregateAnnotation().snapshotTriggerDefinition());
    }

    Optional<String> type() {
        return StringUtilities.createOptional(this.getAggregateAnnotation().type());
    }

    Optional<String> commandTargetResolver() {
        return StringUtilities.createOptional(this.getAggregateAnnotation().commandTargetResolver());
    }

    private Aggregate getAggregateAnnotation() {
        return this.aggregateType.getAnnotation(Aggregate.class);
    }

    boolean isJpaAggregate() {
        return Arrays.stream(this.aggregateType.getAnnotations()).map(Annotation::annotationType).map(Class::getName).anyMatch("javax.persistence.Entity"::equals);
    }
}

