/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi.messaging.annotation;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.axonframework.cdi.CdiUtilities;
import org.axonframework.cdi.messaging.annotation.CdiParameterResolver;
import org.axonframework.common.Priority;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=-1073741824)
public class CdiParameterResolverFactory
implements ParameterResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BeanManager beanManager = CdiUtilities.getBeanManager();

    public ParameterResolver<?> createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (this.beanManager == null) {
            logger.error("BeanManager was null. This is a fatal error, an instance of {} {} is not created.", parameter.getType(), (Object)parameter.getAnnotations());
            return null;
        }
        logger.trace("Create instance for {} {}.", parameter.getType(), (Object)parameter.getAnnotations());
        Set beansFound = this.beanManager.getBeans(parameter.getType(), parameter.getAnnotations());
        if (beansFound.isEmpty()) {
            return null;
        }
        if (beansFound.size() > 1) {
            if (logger.isWarnEnabled()) {
                logger.warn("Ambiguous reference for parameter type {} with qualifiers {}.", (Object)parameter.getType().getName(), (Object)parameter.getAnnotations());
            }
            return null;
        }
        return new CdiParameterResolver(this.beanManager, (Bean)beansFound.iterator().next(), parameter.getType());
    }
}

