/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Named;

public class CdiUtilities {
    public static <T> T getReference(BeanManager beanManager, Bean<T> bean, Type beanType) {
        return (T)beanManager.getReference(bean, beanType, beanManager.createCreationalContext(bean));
    }

    public static <T> T getReference(BeanManager beanManager, Class<T> clazz) {
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, clazz, creationalContext);
    }

    public static final boolean hasAnnotatedMethod(Bean<?> bean, Class<? extends Annotation> clazz) {
        return CdiUtilities.getDeclaredMethodsTransitive(bean.getBeanClass()).anyMatch(m -> m.isAnnotationPresent(clazz));
    }

    @SafeVarargs
    public static boolean hasAnnotatedMember(Bean<?> bean, Class<? extends Annotation> ... classes) {
        Predicate<Field> hasAllAnnotations = field -> Arrays.stream(classes).allMatch(field::isAnnotationPresent);
        return Arrays.stream(bean.getBeanClass().getDeclaredFields()).anyMatch(hasAllAnnotations);
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    static String extractBeanName(AnnotatedMember<?> annotatedMember) {
        Named named = (Named)annotatedMember.getAnnotation(Named.class);
        if (named != null && !"".equals(named.value())) {
            return named.value();
        }
        return annotatedMember.getJavaMember().getName();
    }

    private static Stream<Method> getDeclaredMethodsTransitive(Class<?> clazz) {
        return clazz == null || clazz.equals(Object.class) ? Stream.empty() : Stream.concat(Arrays.stream(clazz.getDeclaredMethods()), CdiUtilities.getDeclaredMethodsTransitive(clazz.getSuperclass()));
    }
}

