/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cdi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Named;
import org.axonframework.cdi.AggregateDefinition;
import org.axonframework.cdi.BeanWrapper;
import org.axonframework.cdi.CdiUtilities;
import org.axonframework.cdi.LazyRetrievedModuleConfiguration;
import org.axonframework.cdi.MessageHandlingBeanDefinition;
import org.axonframework.cdi.SagaDefinition;
import org.axonframework.cdi.stereotype.Aggregate;
import org.axonframework.cdi.stereotype.Saga;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.model.GenericJpaRepository;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonCdiExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<AggregateDefinition> aggregates = new ArrayList<AggregateDefinition>();
    private final Map<String, Producer<Repository>> aggregateRepositoryProducerMap = new HashMap<String, Producer<Repository>>();
    private final Map<String, Producer<SnapshotTriggerDefinition>> snapshotTriggerDefinitionProducerMap = new HashMap<String, Producer<SnapshotTriggerDefinition>>();
    private final Map<String, Producer<CommandTargetResolver>> commandTargetResolverProducerMap = new HashMap<String, Producer<CommandTargetResolver>>();
    private final List<SagaDefinition> sagas = new ArrayList<SagaDefinition>();
    private final Map<String, Producer<SagaStore>> sagaStoreProducerMap = new HashMap<String, Producer<SagaStore>>();
    private final Map<String, Producer<SagaConfiguration<?>>> sagaConfigurationProducerMap = new HashMap();
    private final List<MessageHandlingBeanDefinition> messageHandlers = new ArrayList<MessageHandlingBeanDefinition>();
    private Producer<EventStorageEngine> eventStorageEngineProducer;
    private Producer<Serializer> serializerProducer;
    private Producer<Serializer> eventSerializerProducer;
    private Producer<Serializer> messageSerializerProducer;
    private Producer<EventBus> eventBusProducer;
    private Producer<CommandBus> commandBusProducer;
    private Producer<CommandGateway> commandGatewayProducer;
    private Producer<Configurer> configurerProducer;
    private Producer<TransactionManager> transactionManagerProducer;
    private Producer<EntityManagerProvider> entityManagerProviderProducer;
    private Producer<TokenStore> tokenStoreProducer;
    private Producer<ListenerInvocationErrorHandler> listenerInvocationErrorHandlerProducer;
    private Producer<ErrorHandler> errorHandlerProducer;
    private final List<Producer<CorrelationDataProvider>> correlationDataProviderProducers = new ArrayList<Producer<CorrelationDataProvider>>();
    private Producer<QueryBus> queryBusProducer;
    private Producer<QueryGateway> queryGatewayProducer;
    private Producer<QueryUpdateEmitter> queryUpdateEmitterProducer;
    private final List<Producer<ModuleConfiguration>> moduleConfigurationProducers = new ArrayList<Producer<ModuleConfiguration>>();
    private final List<Producer<ConfigurerModule>> configurerModuleProducers = new ArrayList<Producer<ConfigurerModule>>();
    private final List<Producer<EventUpcaster>> eventUpcasterProducers = new ArrayList<Producer<EventUpcaster>>();
    private Producer<DeadlineManager> deadlineManagerProducer;
    private Producer<EventHandlingConfiguration> eventHandlingConfigurationProducer;
    private Producer<EventProcessingConfiguration> eventProcessingConfigurationProducer;

    <T> void processAggregate(@Observes @WithAnnotations(value={Aggregate.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        Class clazz = processAnnotatedType.getAnnotatedType().getJavaClass();
        logger.debug("Found aggregate: {}.", (Object)clazz);
        this.aggregates.add(new AggregateDefinition(clazz));
    }

    <T> void processAggregateRepositoryProducer(@Observes ProcessProducer<T, Repository> processProducer) {
        logger.debug("Found producer for repository: {}.", (Object)processProducer.getProducer());
        String repositoryName = CdiUtilities.extractBeanName(processProducer.getAnnotatedMember());
        this.aggregateRepositoryProducerMap.put(repositoryName, (Producer<Repository>)processProducer.getProducer());
    }

    <T> void processSnapshotTriggerDefinitionProducer(@Observes ProcessProducer<T, SnapshotTriggerDefinition> processProducer) {
        logger.debug("Found producer for snapshot trigger definition: {}.", (Object)processProducer.getProducer());
        String triggerDefinitionName = CdiUtilities.extractBeanName(processProducer.getAnnotatedMember());
        this.snapshotTriggerDefinitionProducerMap.put(triggerDefinitionName, (Producer<SnapshotTriggerDefinition>)processProducer.getProducer());
    }

    <T> void processCommandTargetResolverProducer(@Observes ProcessProducer<T, CommandTargetResolver> processProducer) {
        logger.debug("Found producer for command target resolver: {}.", (Object)processProducer.getProducer());
        String resolverName = CdiUtilities.extractBeanName(processProducer.getAnnotatedMember());
        this.commandTargetResolverProducerMap.put(resolverName, (Producer<CommandTargetResolver>)processProducer.getProducer());
    }

    <T> void processSaga(@Observes @WithAnnotations(value={Saga.class}) ProcessAnnotatedType<T> processAnnotatedType) {
        Class clazz = processAnnotatedType.getAnnotatedType().getJavaClass();
        logger.debug("Found saga: {}.", (Object)clazz);
        this.sagas.add(new SagaDefinition(clazz));
    }

    <T> void processEventStorageEngineProducer(@Observes ProcessProducer<T, EventStorageEngine> processProducer) {
        logger.debug("Producer for event storage engine found: {}.", (Object)processProducer.getProducer());
        this.eventStorageEngineProducer = processProducer.getProducer();
    }

    <T> void processSagaConfigurationProducer(@Observes ProcessProducer<T, SagaConfiguration<?>> processProducer) {
        logger.debug("Producer for saga configuration found: {}.", (Object)processProducer.getProducer());
        String sagaConfigurationName = CdiUtilities.extractBeanName(processProducer.getAnnotatedMember());
        this.sagaConfigurationProducerMap.put(sagaConfigurationName, processProducer.getProducer());
    }

    <T> void processConfigurerProducer(@Observes ProcessProducer<T, Configurer> processProducer) {
        logger.debug("Producer for configurer found: {}.", (Object)processProducer.getProducer());
        this.configurerProducer = processProducer.getProducer();
    }

    <T> void processTransactionManagerProducer(@Observes ProcessProducer<T, TransactionManager> processProducer) {
        logger.debug("Producer for transaction manager found: {}.", (Object)processProducer.getProducer());
        this.transactionManagerProducer = processProducer.getProducer();
    }

    <T> void processSerializerProducer(@Observes ProcessProducer<T, Serializer> processProducer) {
        AnnotatedMember annotatedMember = processProducer.getAnnotatedMember();
        Named named = (Named)annotatedMember.getAnnotation(Named.class);
        if (named != null) {
            String serializerName;
            String namedValue = named.value();
            switch (serializerName = "".equals(namedValue) ? annotatedMember.getJavaMember().getName() : namedValue) {
                case "eventSerializer": {
                    logger.debug("Producer for event serializer found: {}.", (Object)processProducer.getProducer());
                    this.eventSerializerProducer = processProducer.getProducer();
                    break;
                }
                case "messageSerializer": {
                    logger.debug("Producer for message serializer found: {}.", (Object)processProducer.getProducer());
                    this.messageSerializerProducer = processProducer.getProducer();
                    break;
                }
                case "serializer": {
                    logger.debug("Producer for serializer found: {}.", (Object)processProducer.getProducer());
                    this.serializerProducer = processProducer.getProducer();
                    break;
                }
                default: {
                    logger.warn("Unknown named serializer configured: " + serializerName);
                    break;
                }
            }
        } else {
            logger.debug("Producer for serializer found: {}.", (Object)processProducer.getProducer());
            this.serializerProducer = processProducer.getProducer();
        }
    }

    <T> void processEventBusProducer(@Observes ProcessProducer<T, EventBus> processProducer) {
        logger.debug("Producer for event bus found: {}.", (Object)processProducer.getProducer());
        this.eventBusProducer = processProducer.getProducer();
    }

    <T> void processCommandBusProducer(@Observes ProcessProducer<T, CommandBus> processProducer) {
        logger.debug("Producer for command bus found: {}.", (Object)processProducer.getProducer());
        this.commandBusProducer = processProducer.getProducer();
    }

    <T> void processCommandGatewayProducer(@Observes ProcessProducer<T, CommandGateway> processProducer) {
        logger.debug("Producer for command gateway found: {}.", (Object)processProducer.getProducer());
        this.commandGatewayProducer = processProducer.getProducer();
    }

    <T> void processEntityManagerProviderProducer(@Observes ProcessProducer<T, EntityManagerProvider> processProducer) {
        logger.debug("Producer for entity manager provider found: {}.", (Object)processProducer.getProducer());
        this.entityManagerProviderProducer = processProducer.getProducer();
    }

    <T> void processTokenStoreProducer(@Observes ProcessProducer<T, TokenStore> processProducer) {
        logger.debug("Producer for token store found: {}.", (Object)processProducer.getProducer());
        this.tokenStoreProducer = processProducer.getProducer();
    }

    <T> void processErrorHandlerProducer(@Observes ProcessProducer<T, ErrorHandler> processProducer) {
        logger.debug("Producer for error handler found: {}.", (Object)processProducer.getProducer());
        this.errorHandlerProducer = processProducer.getProducer();
    }

    <T> void processListenerInvocationErrorHandlerProducer(@Observes ProcessProducer<T, ListenerInvocationErrorHandler> processProducer) {
        logger.debug("Producer for listener invocation error handler found: {}.", (Object)processProducer.getProducer());
        this.listenerInvocationErrorHandlerProducer = processProducer.getProducer();
    }

    <T> void processCorrelationDataProviderProducer(@Observes ProcessProducer<T, CorrelationDataProvider> processProducer) {
        logger.debug("Producer for correlation data provider found: {}.", (Object)processProducer.getProducer());
        this.correlationDataProviderProducers.add((Producer<CorrelationDataProvider>)processProducer.getProducer());
    }

    <T> void processQueryBusProducer(@Observes ProcessProducer<T, QueryBus> processProducer) {
        logger.debug("Producer for query bus found: {}.", (Object)processProducer.getProducer());
        this.queryBusProducer = processProducer.getProducer();
    }

    <T> void processQueryGatewayProducer(@Observes ProcessProducer<T, QueryGateway> processProducer) {
        logger.debug("Producer for query gateway found: {}.", (Object)processProducer.getProducer());
        this.queryGatewayProducer = processProducer.getProducer();
    }

    <T> void processQueryUpdateEmitterProducer(@Observes ProcessProducer<T, QueryUpdateEmitter> processProducer) {
        logger.debug("Producer for query update emitter found: {}.", (Object)processProducer.getProducer());
        this.queryUpdateEmitterProducer = processProducer.getProducer();
    }

    <T> void processDeadlineManagerProducer(@Observes ProcessProducer<T, DeadlineManager> processProducer) {
        logger.debug("Producer for deadline manager found: {}.", (Object)processProducer.getProducer());
        this.deadlineManagerProducer = processProducer.getProducer();
    }

    <T> void processModuleConfigurationProducer(@Observes ProcessProducer<T, ModuleConfiguration> processProducer) {
        logger.debug("Producer for module configuration found: {}.", (Object)processProducer.getProducer());
        this.moduleConfigurationProducers.add((Producer<ModuleConfiguration>)processProducer.getProducer());
    }

    <T> void processEventHandlingConfigurationProducer(@Observes ProcessProducer<T, EventHandlingConfiguration> processProducer) {
        logger.debug("Producer for event handling configuration found: {}.", (Object)processProducer.getProducer());
        this.eventHandlingConfigurationProducer = processProducer.getProducer();
    }

    <T> void processEventProcessingConfigurationProducer(@Observes ProcessProducer<T, EventProcessingConfiguration> processProducer) {
        logger.debug("Producer for event processing configuration found: {}.", (Object)processProducer.getProducer());
        this.eventProcessingConfigurationProducer = processProducer.getProducer();
    }

    <T> void processConfigurerModuleProducer(@Observes ProcessProducer<T, ConfigurerModule> processProducer) {
        logger.debug("Producer for configurer module found: {}.", (Object)processProducer.getProducer());
        this.configurerModuleProducers.add((Producer<ConfigurerModule>)processProducer.getProducer());
    }

    <T> void processSagaStoreProducer(@Observes ProcessProducer<T, SagaStore> processProducer) {
        logger.debug("Producer for saga store found: {}.", (Object)processProducer.getProducer());
        String sagaStoreName = CdiUtilities.extractBeanName(processProducer.getAnnotatedMember());
        this.sagaStoreProducerMap.put(sagaStoreName, (Producer<SagaStore>)processProducer.getProducer());
    }

    <T> void processEventUpcasterProducer(@Observes ProcessProducer<T, EventUpcaster> processProducer) {
        logger.debug("Producer for event upcaster found: {}.", (Object)processProducer.getProducer());
        this.eventUpcasterProducers.add((Producer<EventUpcaster>)processProducer.getProducer());
    }

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        MessageHandlingBeanDefinition.inspect(processBean.getBean()).ifPresent(bean -> {
            logger.debug("Found {}.", bean);
            this.messageHandlers.add((MessageHandlingBeanDefinition)bean);
        });
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Serializer serializer;
        Configurer configurer;
        logger.info("Starting Axon Framework configuration.");
        if (this.configurerProducer != null) {
            configurer = this.produce(beanManager, this.configurerProducer);
            logger.info("Starting with an application provided configurer: {}.", (Object)configurer.getClass().getSimpleName());
        } else {
            logger.info("Starting with the Axon default configuration.");
            configurer = DefaultConfigurer.defaultConfiguration();
        }
        if (this.entityManagerProviderProducer != null) {
            EntityManagerProvider entityManagerProvider = this.produce(beanManager, this.entityManagerProviderProducer);
            logger.info("Registering entity manager provider: {}.", (Object)entityManagerProvider.getClass().getSimpleName());
            configurer.registerComponent(EntityManagerProvider.class, c -> entityManagerProvider);
        }
        if (this.serializerProducer != null) {
            serializer = this.produce(beanManager, this.serializerProducer);
            logger.info("Registering serializer: {}.", (Object)serializer.getClass().getSimpleName());
            configurer.configureSerializer(c -> serializer);
        }
        if (this.eventSerializerProducer != null) {
            serializer = this.produce(beanManager, this.eventSerializerProducer);
            logger.info("Registering event serializer: {}.", (Object)serializer.getClass().getSimpleName());
            configurer.configureEventSerializer(c -> serializer);
        }
        if (this.messageSerializerProducer != null) {
            serializer = this.produce(beanManager, this.messageSerializerProducer);
            logger.info("Registering message serializer: {}.", (Object)serializer.getClass().getSimpleName());
            configurer.configureMessageSerializer(c -> serializer);
        }
        if (this.transactionManagerProducer != null) {
            TransactionManager transactionManager = this.produce(beanManager, this.transactionManagerProducer);
            logger.info("Registering transaction manager: {}.", (Object)transactionManager.getClass().getSimpleName());
            configurer.configureTransactionManager(c -> transactionManager);
        }
        if (this.commandBusProducer != null) {
            CommandBus commandBus = this.produce(beanManager, this.commandBusProducer);
            logger.info("Registering command bus: {}.", (Object)commandBus.getClass().getSimpleName());
            configurer.configureCommandBus(c -> commandBus);
        }
        for (Producer producer2 : this.moduleConfigurationProducers) {
            configurer.registerModule((ModuleConfiguration)new LazyRetrievedModuleConfiguration(() -> {
                ModuleConfiguration moduleConfiguration = (ModuleConfiguration)producer2.produce(beanManager.createCreationalContext(null));
                logger.info("Registering module configuration: {}.", (Object)moduleConfiguration.getClass().getSimpleName());
                return moduleConfiguration;
            }));
        }
        EventHandlingConfiguration eventHandlingConfiguration = this.eventHandlingConfigurationProducer != null ? this.produce(beanManager, this.eventHandlingConfigurationProducer) : new EventHandlingConfiguration();
        logger.info("Registering event handling configuration: {}.", (Object)eventHandlingConfiguration.getClass().getSimpleName());
        configurer.registerModule((ModuleConfiguration)eventHandlingConfiguration);
        if (this.eventProcessingConfigurationProducer != null) {
            EventProcessingConfiguration eventProcessingConfiguration = this.produce(beanManager, this.eventProcessingConfigurationProducer);
            logger.info("Registering event processing configuration: {}.", (Object)eventProcessingConfiguration.getClass().getSimpleName());
            configurer.registerModule((ModuleConfiguration)eventProcessingConfiguration);
        }
        this.configurerModuleProducers.forEach(producer -> {
            ConfigurerModule configurerModule = (ConfigurerModule)this.produce(beanManager, (Producer)producer);
            logger.info("Configuring module: {}.", (Object)configurerModule.getClass().getSimpleName());
            configurerModule.configureModule(configurer);
        });
        if (this.eventBusProducer != null) {
            EventBus eventBus = this.produce(beanManager, this.eventBusProducer);
            logger.info("Registering event bus: {}.", (Object)eventBus.getClass().getSimpleName());
            configurer.configureEventBus(c -> eventBus);
        }
        if (this.tokenStoreProducer != null) {
            TokenStore tokenStore = this.produce(beanManager, this.tokenStoreProducer);
            logger.info("Registering token store: {}.", (Object)tokenStore.getClass().getSimpleName());
            configurer.registerComponent(TokenStore.class, c -> tokenStore);
        }
        if (this.listenerInvocationErrorHandlerProducer != null) {
            ListenerInvocationErrorHandler listenerInvocationErrorHandler = this.produce(beanManager, this.listenerInvocationErrorHandlerProducer);
            logger.info("Registering listener invocation error handler: {}.", (Object)listenerInvocationErrorHandler.getClass().getSimpleName());
            configurer.registerComponent(ListenerInvocationErrorHandler.class, c -> listenerInvocationErrorHandler);
        }
        if (this.errorHandlerProducer != null) {
            ErrorHandler errorHandler = this.produce(beanManager, this.errorHandlerProducer);
            logger.info("Registering error handler: {}.", (Object)errorHandler.getClass().getSimpleName());
            configurer.registerComponent(ErrorHandler.class, c -> errorHandler);
        }
        List list = this.correlationDataProviderProducers.stream().map(producer -> {
            CorrelationDataProvider correlationDataProvider = (CorrelationDataProvider)this.produce(beanManager, (Producer)producer);
            logger.info("Registering correlation data provider: {}.", (Object)correlationDataProvider.getClass().getSimpleName());
            return correlationDataProvider;
        }).collect(Collectors.toList());
        configurer.configureCorrelationDataProviders(c -> correlationDataProviders);
        this.eventUpcasterProducers.forEach(producer -> {
            EventUpcaster eventUpcaster = (EventUpcaster)this.produce(beanManager, (Producer)producer);
            logger.info("Registering event upcaster: {}.", (Object)eventUpcaster.getClass().getSimpleName());
            configurer.registerEventUpcaster(c -> eventUpcaster);
        });
        if (this.queryBusProducer != null) {
            QueryBus queryBus = this.produce(beanManager, this.queryBusProducer);
            logger.info("Registering query bus: {}.", (Object)queryBus.getClass().getSimpleName());
            configurer.configureQueryBus(c -> queryBus);
        }
        if (this.queryGatewayProducer != null) {
            QueryGateway queryGateway = this.produce(beanManager, this.queryGatewayProducer);
            logger.info("Registering query gateway: {}.", (Object)queryGateway.getClass().getSimpleName());
            configurer.registerComponent(QueryGateway.class, c -> queryGateway);
        }
        if (this.queryUpdateEmitterProducer != null) {
            QueryUpdateEmitter queryUpdateEmitter = this.produce(beanManager, this.queryUpdateEmitterProducer);
            logger.info("Registering query update emitter: {}.", (Object)queryUpdateEmitter.getClass().getSimpleName());
            configurer.configureQueryUpdateEmitter(c -> queryUpdateEmitter);
        }
        if (this.deadlineManagerProducer != null) {
            DeadlineManager deadlineManager = this.produce(beanManager, this.deadlineManagerProducer);
            logger.info("Registering deadline manager: {}.", (Object)deadlineManager.getClass().getSimpleName());
            configurer.registerComponent(DeadlineManager.class, c -> deadlineManager);
        }
        if (this.eventStorageEngineProducer != null) {
            EventStorageEngine eventStorageEngine = this.produce(beanManager, this.eventStorageEngineProducer);
            logger.info("Registering event storage: {}.", (Object)eventStorageEngine.getClass().getSimpleName());
            configurer.configureEmbeddedEventStore(c -> eventStorageEngine);
        }
        this.registerAggregates(beanManager, configurer);
        this.registerSagaStore(beanManager, configurer);
        this.registerSagas(beanManager, afterBeanDiscovery, configurer);
        this.registerMessageHandlers(beanManager, configurer, eventHandlingConfiguration);
        logger.info("Axon Framework configuration complete.");
        logger.info("Registering Axon APIs with CDI.");
        afterBeanDiscovery.addBean(new BeanWrapper<Configuration>(Configuration.class, () -> this.startConfiguration(configurer)));
        this.addIfNotConfigured(CommandGateway.class, this.commandGatewayProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).commandGateway(), afterBeanDiscovery);
        this.addIfNotConfigured(CommandBus.class, this.commandBusProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).commandBus(), afterBeanDiscovery);
        this.addIfNotConfigured(QueryBus.class, this.queryBusProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).queryBus(), afterBeanDiscovery);
        this.addIfNotConfigured(QueryGateway.class, this.queryGatewayProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).queryGateway(), afterBeanDiscovery);
        this.addIfNotConfigured(QueryUpdateEmitter.class, this.queryUpdateEmitterProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).queryUpdateEmitter(), afterBeanDiscovery);
        this.addIfNotConfigured(EventBus.class, this.eventBusProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).eventBus(), afterBeanDiscovery);
        this.addIfNotConfigured(Serializer.class, this.serializerProducer, () -> CdiUtilities.getReference(beanManager, Configuration.class).serializer(), afterBeanDiscovery);
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        CdiUtilities.getReference(beanManager, Configuration.class).commandBus();
    }

    void init(@Observes @Initialized(value=ApplicationScoped.class) Object initialized) {
    }

    void destroy(@Observes @Destroyed(value=ApplicationScoped.class) Object destroyed) {
    }

    void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }

    private Configuration startConfiguration(Configurer configurer) {
        logger.info("Starting Axon configuration.");
        return configurer.start();
    }

    private void registerMessageHandlers(BeanManager beanManager, Configurer configurer, EventHandlingConfiguration eventHandlingConfiguration) {
        for (MessageHandlingBeanDefinition messageHandler : this.messageHandlers) {
            Component component = new Component(() -> null, "messageHandler", c -> messageHandler.getBean().create(beanManager.createCreationalContext(null)));
            if (messageHandler.isEventHandler()) {
                logger.info("Registering event handler: {}.", (Object)messageHandler.getBean().getBeanClass().getSimpleName());
                eventHandlingConfiguration.registerEventHandler(c -> component.get());
            }
            if (messageHandler.isCommandHandler()) {
                logger.info("Registering command handler: {}.", (Object)messageHandler.getBean().getBeanClass().getSimpleName());
                configurer.registerCommandHandler(c -> component.get());
            }
            if (!messageHandler.isQueryHandler()) continue;
            logger.info("Registering query handler: {}.", (Object)messageHandler.getBean().getBeanClass().getSimpleName());
            configurer.registerQueryHandler(c -> component.get());
        }
    }

    private void registerAggregates(BeanManager beanManager, Configurer configurer) {
        this.aggregates.forEach(aggregateDefinition -> {
            logger.info("Registering aggregate: {}.", (Object)aggregateDefinition.aggregateType().getSimpleName());
            AggregateConfigurer aggregateConfigurer = AggregateConfigurer.defaultConfiguration(aggregateDefinition.aggregateType());
            if (aggregateDefinition.repository().isPresent()) {
                aggregateConfigurer.configureRepository(c -> this.produce(beanManager, this.aggregateRepositoryProducerMap.get(aggregateDefinition.repository().get())));
            } else if (this.aggregateRepositoryProducerMap.containsKey(aggregateDefinition.repositoryName())) {
                aggregateConfigurer.configureRepository(c -> this.produce(beanManager, this.aggregateRepositoryProducerMap.get(aggregateDefinition.repositoryName())));
            } else {
                aggregateDefinition.snapshotTriggerDefinition().ifPresent(triggerDefinition -> aggregateConfigurer.configureSnapshotTrigger(c -> this.produce(beanManager, this.snapshotTriggerDefinitionProducerMap.get(triggerDefinition))));
                if (aggregateDefinition.isJpaAggregate()) {
                    aggregateConfigurer.configureRepository(c -> new GenericJpaRepository((EntityManagerProvider)c.getComponent(EntityManagerProvider.class), aggregateDefinition.aggregateType(), c.eventBus(), arg_0 -> ((Configuration)c).repository(arg_0), (LockFactory)c.getComponent(LockFactory.class, () -> NullLockFactory.INSTANCE), c.parameterResolverFactory(), c.handlerDefinition(aggregateDefinition.aggregateType())));
                }
            }
            if (aggregateDefinition.commandTargetResolver().isPresent()) {
                aggregateConfigurer.configureCommandTargetResolver(c -> this.produce(beanManager, this.commandTargetResolverProducerMap.get(aggregateDefinition.commandTargetResolver().get())));
            } else {
                this.commandTargetResolverProducerMap.keySet().stream().filter(resolver -> this.aggregates.stream().filter(a -> a.commandTargetResolver().isPresent()).map(a -> a.commandTargetResolver().get()).noneMatch(resolver::equals)).findFirst().ifPresent(resolver -> aggregateConfigurer.configureCommandTargetResolver(c -> this.produce(beanManager, this.commandTargetResolverProducerMap.get(resolver))));
            }
            configurer.configureAggregate((AggregateConfiguration)aggregateConfigurer);
        });
    }

    private void registerSagaStore(BeanManager beanManager, Configurer configurer) {
        this.sagaStoreProducerMap.keySet().stream().filter(storeName -> this.sagas.stream().filter(sd -> sd.sagaStore().isPresent()).map(sd -> sd.sagaStore().get()).noneMatch(storeName::equals)).findFirst().ifPresent(storeName -> {
            SagaStore sagaStore = this.produce(beanManager, this.sagaStoreProducerMap.get(storeName));
            logger.info("Registering saga store {}.", (Object)sagaStore.getClass().getSimpleName());
            configurer.registerComponent(SagaStore.class, c -> sagaStore);
        });
    }

    private void registerSagas(BeanManager beanManager, AfterBeanDiscovery afterBeanDiscovery, Configurer configurer) {
        this.sagas.forEach(sagaDefinition -> {
            logger.info("Registering saga {}.", (Object)sagaDefinition.sagaType().getSimpleName());
            if (!sagaDefinition.explicitConfiguration() && !this.sagaConfigurationProducerMap.containsKey(sagaDefinition.configurationName())) {
                SagaConfiguration sagaConfiguration = SagaConfiguration.subscribingSagaManager(sagaDefinition.sagaType());
                afterBeanDiscovery.addBean(new BeanWrapper<SagaConfiguration>(sagaDefinition.configurationName(), SagaConfiguration.class, () -> sagaConfiguration));
                sagaDefinition.sagaStore().ifPresent(sagaStore -> sagaConfiguration.configureSagaStore(c -> this.produce(beanManager, this.sagaStoreProducerMap.get(sagaStore))));
                configurer.registerModule((ModuleConfiguration)sagaConfiguration);
            }
        });
    }

    private <T> void addIfNotConfigured(Class<T> componentType, Producer<T> componentProducer, Supplier<T> componentSupplier, AfterBeanDiscovery afterBeanDiscovery) {
        if (componentProducer == null) {
            afterBeanDiscovery.addBean(new BeanWrapper<T>(componentType, componentSupplier));
        }
    }

    private <T> T produce(BeanManager beanManager, Producer<T> producer) {
        return (T)producer.produce(beanManager.createCreationalContext(null));
    }
}

