/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Map;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.dynamodb.utils.Comparator;
import org.awsutils.dynamodb.utils.DoubleValueComparator;
import org.awsutils.dynamodb.utils.Expr;
import org.awsutils.dynamodb.utils.FilterExpr;
import org.awsutils.dynamodb.utils.Group;
import org.awsutils.dynamodb.utils.Name;
import org.awsutils.dynamodb.utils.Operator;
import org.awsutils.dynamodb.utils.SingleValueComparator;
import org.awsutils.dynamodb.utils.Value;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class FilterExprImpl
implements FilterExpr {
    private NameImpl rootName;
    private GroupImpl rootGroup;

    FilterExprImpl() {
    }

    public static FilterExpr getInstance() {
        return new FilterExprImpl();
    }

    @Override
    public Name name(String name, String alias) {
        this.rootName = new NameImpl(name, alias, this);
        return this.rootName;
    }

    @Override
    public Group group(Expr expr) {
        this.rootGroup = new GroupImpl(this, expr);
        return this.rootGroup;
    }

    @Override
    public Name name(String name) {
        return this.name(name, name);
    }

    private static class NameImpl
    implements Name {
        private final String name;
        private final String alias;
        private final FilterExprImpl filterExpression;
        private AbstractComparator comparator;

        public NameImpl(String name, String alias, FilterExprImpl filterExpression) {
            this.name = name;
            this.alias = alias;
            this.filterExpression = filterExpression;
        }

        @Override
        public SingleValueComparator gt() {
            this.comparator = new GreaterThan(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator lt() {
            this.comparator = new LessThan(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator gte() {
            this.comparator = new GreaterThanOrEquals(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator lte() {
            this.comparator = new LessThanOrEquals(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator eq() {
            this.comparator = new Equals(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator ne() {
            this.comparator = new NotEquals(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public SingleValueComparator notExists() {
            this.comparator = new NotExists(this.filterExpression);
            return (SingleValueComparator)((Object)this.comparator);
        }

        @Override
        public DoubleValueComparator between() {
            this.comparator = new Between(this.filterExpression);
            return (DoubleValueComparator)((Object)this.comparator);
        }

        String expression() {
            if (!(this.comparator instanceof NotExists) && !(this.comparator instanceof Between)) {
                SingleValueImpl value = (SingleValueImpl)this.comparator.value;
                if (value == null) {
                    throw new UtilsException("Invalid Expression");
                }
                AbstractOperator operator = value.operator();
                return MessageFormat.format("#{0}{1}:{2}{3}", this.alias, this.comparator.expression(), value.name, operator == null ? "" : operator.expression());
            }
            if (this.comparator instanceof Between) {
                DoubleValueImpl value = (DoubleValueImpl)this.comparator.value;
                if (value.value1 == null || value.value2 == null) {
                    throw new UtilsException("Invalid Expression");
                }
                AbstractOperator operator = value.operator();
                return MessageFormat.format("#{0}{1}:{2} and :{3} {4}", this.alias, this.comparator.expression(), value.value1.name, value.value2.name, operator == null ? "" : operator.expression() + " ");
            }
            return MessageFormat.format(this.comparator.expression(), this.name);
        }

        Map<String, String> attributeNameMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (!(this.comparator instanceof NotExists)) {
                AbstractValueImpl value = (AbstractValueImpl)this.comparator.value;
                AbstractOperator operator = value.operator();
                builder.put((Object)("#" + this.alias), (Object)this.name);
                if (operator != null) {
                    builder.putAll(operator.attributeNameMap());
                }
                return builder.build();
            }
            return builder.build();
        }

        Map<String, AttributeValue> attributeValueMap() {
            if (!(this.comparator instanceof NotExists) && !(this.comparator instanceof Between)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                SingleValueImpl value = (SingleValueImpl)this.comparator.value;
                AbstractOperator operator = value.operator();
                builder.put((Object)(":" + value.name), (Object)value.value);
                if (operator != null) {
                    builder.putAll(operator.attributeValueMap());
                }
                return builder.build();
            }
            if (this.comparator instanceof Between) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                DoubleValueImpl value = (DoubleValueImpl)this.comparator.value;
                AbstractOperator operator = value.operator();
                builder.put((Object)(":" + value.value1.name), (Object)value.value1.value);
                builder.put((Object)(":" + value.value2.name), (Object)value.value2.value);
                if (operator != null) {
                    builder.putAll(operator.attributeValueMap());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public String toString() {
            return "Name{name='" + this.name + "', alias='" + this.alias + "', comparator=" + String.valueOf(this.comparator) + "}";
        }
    }

    private static final class GroupImpl
    implements Group {
        private AbstractOperator operator;
        private final FilterExprImpl filterExpr;
        private final Expr expr;

        private GroupImpl(FilterExprImpl filterExpr, Expr expr) {
            this.filterExpr = filterExpr;
            this.expr = expr;
        }

        @Override
        public Operator and() {
            this.operator = new And(this.filterExpr);
            return this.operator;
        }

        @Override
        public Operator or() {
            this.operator = new Or(this.filterExpr);
            return this.operator;
        }

        @Override
        public String expression() {
            return this.operator != null ? MessageFormat.format("({0}) {1}", this.expr.expression(), this.operator.expression()) : MessageFormat.format("({0})", this.expr.expression());
        }

        public Map<String, String> attributeNameMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.expr.attributeNameMap());
            if (this.operator != null) {
                builder.putAll(this.operator.attributeNameMap());
            }
            return builder.build();
        }

        public Map<String, AttributeValue> attributeValueMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.expr.attributeValueMap());
            if (this.operator != null) {
                builder.putAll(this.operator.attributeValueMap());
            }
            return builder.build();
        }

        @Override
        public Expr buildFilterExpression() {
            if (this.operator != null) {
                throw new UtilsException("Invalid expression.");
            }
            ExprImpl expr = new ExprImpl(this.filterExpr);
            return (Expr)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Expr.class}, (proxy, method, args) -> method.invoke((Object)expr, args));
        }
    }

    private static final class Or
    extends AbstractOperator {
        private Or(String name, String alias, FilterExprImpl filterExpression) {
            super(name, alias, filterExpression);
        }

        public Or(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String toString() {
            return "Or{} " + super.toString();
        }

        @Override
        protected String getExpression() {
            return " or ";
        }
    }

    private static final class And
    extends AbstractOperator {
        private And(String name, String alias, FilterExprImpl filterExpression) {
            super(name, alias, filterExpression);
        }

        public And(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        protected String getExpression() {
            return " and ";
        }
    }

    private static abstract class AbstractOperator
    implements Operator {
        private NameImpl nextName;
        private final FilterExprImpl filterExpr;
        private GroupImpl group;

        protected AbstractOperator(String nextName, String alias, FilterExprImpl filterExpression) {
            this.nextName = new NameImpl(nextName, alias, filterExpression);
            this.filterExpr = filterExpression;
        }

        protected AbstractOperator(FilterExprImpl filterExpression) {
            this.filterExpr = filterExpression;
        }

        @Override
        public String expression() {
            if (this.nextName == null && this.group == null) {
                throw new UtilsException("Invalid expression.");
            }
            return this.getExpression() + (this.nextName != null ? this.nextName.expression() : this.group.expression());
        }

        protected abstract String getExpression();

        public String toString() {
            return "AbstractOperator{nextName=" + String.valueOf(this.nextName) + "}";
        }

        @Override
        public Name name(String name, String alias) {
            this.nextName = new NameImpl(name, alias, this.filterExpr);
            return this.nextName;
        }

        @Override
        public Group group(Expr expr) {
            this.group = new GroupImpl(this.filterExpr, expr);
            return this.group;
        }

        public Map<String, String> attributeNameMap() {
            return this.nextName != null ? this.nextName.attributeNameMap() : this.group.attributeNameMap();
        }

        public Map<String, AttributeValue> attributeValueMap() {
            return this.nextName != null ? this.nextName.attributeValueMap() : this.group.attributeValueMap();
        }
    }

    private static final class SingleValueImpl
    extends AbstractValueImpl {
        private final AttributeValue value;
        private final String name;

        private SingleValueImpl(String name, AttributeValue value, FilterExprImpl filterExpression) {
            super(filterExpression);
            this.name = name;
            this.value = value;
        }

        @Override
        public String toString() {
            return "ValueImpl{value=" + String.valueOf(this.value) + ", name='" + this.name + "'} " + super.toString();
        }
    }

    private static final class DoubleValueImpl
    extends AbstractValueImpl {
        private final SingleValueImpl value1;
        private final SingleValueImpl value2;

        public DoubleValueImpl(SingleValueImpl value1, SingleValueImpl value2, FilterExprImpl filterExpression) {
            super(filterExpression);
            this.value1 = value1;
            this.value2 = value2;
        }

        @Override
        public String toString() {
            return "DoubleValueImpl{value1=" + String.valueOf(this.value1) + ", value2=" + String.valueOf(this.value2) + "} " + super.toString();
        }
    }

    private static abstract class AbstractValueImpl
    implements Value {
        private AbstractOperator operator;
        private final FilterExprImpl filterExpression;

        private AbstractValueImpl(FilterExprImpl filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public Name and(String name, String alias) {
            this.operator = new And(name, alias, this.filterExpression);
            return this.operator.nextName;
        }

        @Override
        public Operator and() {
            this.operator = new And(this.filterExpression);
            return this.operator;
        }

        @Override
        public Name and(String name) {
            return this.and(name, name);
        }

        @Override
        public Name or(String name, String alias) {
            this.operator = new Or(name, alias, this.filterExpression);
            return this.operator.nextName;
        }

        @Override
        public Operator or() {
            this.operator = new Or(this.filterExpression);
            return this.operator;
        }

        @Override
        public Name or(String name) {
            return this.or(name, name);
        }

        @Override
        public Expr buildFilterExpression() {
            return new ExprImpl(this.filterExpression);
        }

        public AbstractOperator operator() {
            return this.operator;
        }

        public String toString() {
            return "AbstractValueImpl{operator=" + String.valueOf(this.operator) + ", filterExpression=" + String.valueOf(this.filterExpression) + "}";
        }
    }

    private static final class NotExists
    extends SingleValueAbstractComparator {
        public NotExists(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public Value value(String name, AttributeValue value) {
            throw new UnsupportedOperationException("This is not supported for a \"Not exists\" check");
        }

        @Override
        public String expression() {
            return "attribute_not_exists({0})";
        }
    }

    private static final class NotEquals
    extends SingleValueAbstractComparator {
        private NotEquals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " <> ";
        }

        @Override
        public String toString() {
            return "NotEquals{} " + super.toString();
        }
    }

    private static final class Equals
    extends SingleValueAbstractComparator {
        private Equals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " = ";
        }

        @Override
        public String toString() {
            return "Equals{} " + super.toString();
        }
    }

    private static final class GreaterThanOrEquals
    extends SingleValueAbstractComparator {
        private GreaterThanOrEquals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " >= ";
        }

        @Override
        public String toString() {
            return "GreaterThanOrEquals{} " + super.toString();
        }
    }

    private static final class LessThanOrEquals
    extends SingleValueAbstractComparator {
        private LessThanOrEquals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " <= ";
        }

        @Override
        public String toString() {
            return "LessThanOrEquals{} " + super.toString();
        }
    }

    private static final class GreaterThan
    extends SingleValueAbstractComparator {
        private GreaterThan(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " > ";
        }

        @Override
        public String toString() {
            return "GreaterThan{} " + super.toString();
        }
    }

    private static final class Between
    extends DoubleValueAbstractComparator {
        public Between(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " between ";
        }

        @Override
        public String toString() {
            return "Between{} " + super.toString();
        }
    }

    private static class LessThan
    extends SingleValueAbstractComparator {
        public LessThan(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " < ";
        }

        @Override
        public String toString() {
            return "LessThan{} " + super.toString();
        }
    }

    private static abstract class DoubleValueAbstractComparator
    extends AbstractComparator
    implements DoubleValueComparator {
        public DoubleValueAbstractComparator(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public Value value(String name1, AttributeValue value1, String name2, AttributeValue value2) {
            this.value = new DoubleValueImpl(new SingleValueImpl(name1, value1, this.filterExpression), new SingleValueImpl(name2, value2, this.filterExpression), this.filterExpression);
            return this.value;
        }

        @Override
        public String toString() {
            return "AbstractComparator{value=" + String.valueOf(this.value) + "}";
        }
    }

    private static abstract class SingleValueAbstractComparator
    extends AbstractComparator
    implements SingleValueComparator {
        protected SingleValueAbstractComparator(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public Value value(String name, AttributeValue value) {
            this.value = new SingleValueImpl(name, value, this.filterExpression);
            return this.value;
        }

        @Override
        public String toString() {
            return "AbstractComparator{} " + super.toString();
        }
    }

    private static abstract class AbstractComparator
    implements Comparator {
        protected Value value;
        protected final FilterExprImpl filterExpression;

        public AbstractComparator(FilterExprImpl filterExpression) {
            this.filterExpression = filterExpression;
        }

        public String toString() {
            return "AbstractComparator1{value=" + String.valueOf(this.value) + ", filterExpression=" + String.valueOf(this.filterExpression) + "}";
        }
    }

    private static final class ExprImpl
    implements Expr {
        private final NameImpl rootNode;
        private final GroupImpl rootGroup;

        private ExprImpl(FilterExprImpl filterExpr) {
            this.rootNode = filterExpr.rootName;
            this.rootGroup = filterExpr.rootGroup;
        }

        @Override
        public String expression() {
            if (this.rootNode != null) {
                return this.rootNode.expression();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.expression();
            }
            throw new UtilsException("Invalid Expression");
        }

        @Override
        public Map<String, String> attributeNameMap() {
            if (this.rootNode != null) {
                return this.rootNode.attributeNameMap();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.attributeNameMap();
            }
            throw new UtilsException("Invalid Expression");
        }

        @Override
        public Map<String, AttributeValue> attributeValueMap() {
            if (this.rootNode != null) {
                return this.rootNode.attributeValueMap();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.attributeValueMap();
            }
            throw new UtilsException("Invalid Expression");
        }
    }
}

