/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import com.google.common.collect.ImmutableList;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.util.PropertyResolverUtils;
import org.awsutils.common.util.Utils;
import org.awsutils.dynamodb.annotations.DDBTable;
import org.awsutils.dynamodb.annotations.DateCreated;
import org.awsutils.dynamodb.annotations.DateUpdated;
import org.awsutils.dynamodb.annotations.DbAttribute;
import org.awsutils.dynamodb.annotations.HashKey;
import org.awsutils.dynamodb.annotations.KeyType;
import org.awsutils.dynamodb.annotations.RangeKey;
import org.awsutils.dynamodb.annotations.SecondaryIndex;
import org.awsutils.dynamodb.annotations.SecondaryIndices;
import org.awsutils.dynamodb.annotations.Transient;
import org.awsutils.dynamodb.annotations.VersionAttribute;
import org.awsutils.dynamodb.data.VersionedEntity;
import org.awsutils.dynamodb.exceptions.DbException;
import org.awsutils.dynamodb.repositories.AttributeMapper;
import org.awsutils.dynamodb.repositories.DataMapper;
import org.awsutils.dynamodb.repositories.DataMapperUtils;
import org.awsutils.dynamodb.repositories.GSI;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public enum MapperUtils {
    INSTANCE;

    private final ConcurrentHashMap<String, AttributeMapper<?>> attributeMappingMap = new ConcurrentHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private <T> List<Field> getAllFields(Class<T> dataClass) {
        return this.getAllFields(dataClass, (List<Field>)ImmutableList.of());
    }

    private List<Field> getAllFields(Class dataClass, List<Field> acc) {
        if (dataClass != VersionedEntity.class && dataClass != Object.class) {
            Field[] fields = dataClass.getDeclaredFields();
            return this.getAllFields(dataClass.getSuperclass(), (List<Field>)ImmutableList.builder().addAll(acc).addAll(fields != null && fields.length > 0 ? Arrays.asList(fields) : Collections.emptyList()).build());
        }
        if (dataClass == VersionedEntity.class) {
            return this.filterFields((List<Field>)ImmutableList.builder().addAll(acc).add((Object)ReflectionUtils.findField(VersionedEntity.class, (String)"version")).build());
        }
        return this.filterFields(acc);
    }

    private List<Field> filterFields(List<Field> fields) {
        return fields.stream().filter(field -> !field.getName().contains("ajc$")).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toList());
    }

    <T> void setDbAttributes(Class<T> dataClass, Environment environment, DataMapper<T> dataMapper) {
        Utils.executeUsingLock((Lock)this.lock.writeLock(), () -> {
            Constructor constructor = this.constructor(dataClass);
            DDBTable table = dataClass.getAnnotation(DDBTable.class);
            List<Field> fields = this.getAllFields(dataClass);
            HashMap<String, Tuple2<Field, DbAttribute>> map = new HashMap<String, Tuple2<Field, DbAttribute>>();
            HashMap<KeyType, Tuple2<String, Field>> primaryKeyMapping = new HashMap<KeyType, Tuple2<String, Field>>();
            HashMap versionAttMap = new HashMap();
            ConcurrentHashMap indexMap = new ConcurrentHashMap();
            String tableName = table != null ? PropertyResolverUtils.getEnvironmentProperty((String)table.name(), (Environment)environment) : dataMapper.tableName();
            AttributeMapper.Builder builder = AttributeMapper.builder();
            fields.forEach(field -> this.setFieldMappings((Map<String, Tuple2<Field, DbAttribute>>)map, (Map<KeyType, Tuple2<String, Field>>)primaryKeyMapping, (Field)field, indexMap, versionAttMap, builder));
            if (!CollectionUtils.isEmpty(versionAttMap) && versionAttMap.size() > 1) {
                throw new DbException("Entity cannot have more than one version attribute");
            }
            if (CollectionUtils.isEmpty(primaryKeyMapping) || primaryKeyMapping.get((Object)KeyType.HASH_KEY) == null) {
                throw new DbException(String.format("Entity class %s does not have a hash key defined", dataClass.getName()));
            }
            this.attributeMappingMap.put(dataClass.getName(), builder.mappedClass(dataClass).mappedFields(map).constructor(constructor).primaryKeyMapping(primaryKeyMapping).globalSecondaryIndexMap(indexMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, b -> ((GSI.Builder)b.getValue()).build()))).versionAttributeField(!CollectionUtils.isEmpty(versionAttMap) ? (Tuple2)versionAttMap.entrySet().iterator().next().getValue() : null).tableName(tableName).build());
        });
    }

    <T> Stream<Tuple4<String, Object, Field, DbAttribute>> getMappedValues(T input, String parameterType) {
        AttributeMapper<?> fieldMapping = this.attributeMappingMap.get(parameterType);
        Map<String, Tuple2<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        Map<KeyType, Tuple2<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        Set pkFields = pkMapping.values().stream().map(Tuple2::_1).collect(Collectors.toSet());
        return fieldMap.entrySet().stream().map(entry -> Tuple.of((Object)((String)entry.getKey()), (Object)((Tuple2)entry.getValue()))).map(a -> Tuple.of((Object)((String)a._1()), (Object)ReflectionUtils.getField((Field)((Field)((Tuple2)a._2())._1()), (Object)input), (Object)((Field)((Tuple2)a._2())._1()), (Object)((DbAttribute)((Tuple2)a._2())._2()))).filter(a -> !pkFields.contains(a._1()));
    }

    <T> Stream<Tuple4<String, Object, Field, DbAttribute>> getMappedValues(T input, Class<T> parameterClass) {
        DataMapper<T> dataMapper = DataMapperUtils.getDataMapper(parameterClass);
        return dataMapper.getMappedValues(input);
    }

    <T> Stream<Tuple3<String, Field, DbAttribute>> getMappedValues(String parameterType) {
        AttributeMapper<?> fieldMapping = this.attributeMappingMap.get(parameterType);
        Map<String, Tuple2<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        Map<KeyType, Tuple2<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        Set pkFields = pkMapping.values().stream().map(Tuple2::_1).collect(Collectors.toSet());
        return fieldMap.entrySet().stream().map(entry -> Tuple.of((Object)((String)entry.getKey()), (Object)((Tuple2)entry.getValue()))).map(a -> Tuple.of((Object)((String)a._1()), (Object)((Field)((Tuple2)a._2())._1()), (Object)((DbAttribute)((Tuple2)a._2())._2()))).filter(a -> !pkFields.contains(a._1()));
    }

    private <T> Constructor<T> constructor(Class<T> dataClass) {
        try {
            Constructor<T> constructor = dataClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException("UNKNOWN_ERROR", "No empty constructor found for " + dataClass.getName(), (Throwable)e);
        }
    }

    private <T> void setFieldMappings(Map<String, Tuple2<Field, DbAttribute>> mappedFields, Map<KeyType, Tuple2<String, Field>> primaryKeyMapping, Field field, ConcurrentHashMap<String, GSI.Builder> indexMap, Map<String, Tuple2<Field, DbAttribute>> versionAttMap, AttributeMapper.Builder<T> builder) {
        field.setAccessible(true);
        List<Annotation> annotations = Arrays.stream(field.getAnnotations()).filter(a -> a instanceof DbAttribute || a instanceof Transient || a instanceof HashKey || a instanceof RangeKey || a instanceof SecondaryIndex || a instanceof SecondaryIndices || a instanceof DateUpdated || a instanceof DateCreated || a instanceof VersionAttribute).collect(Collectors.toList());
        if (!this.isTransient(annotations)) {
            if (this.isAnnotatedCorrectly(annotations)) {
                List<SecondaryIndex> gsiList;
                DbAttribute dbAttribute = !CollectionUtils.isEmpty(annotations) ? (DbAttribute)annotations.stream().filter(a -> a instanceof DbAttribute).findAny().orElse(null) : null;
                DateCreated dateCreated = !CollectionUtils.isEmpty(annotations) ? (DateCreated)annotations.stream().filter(a -> a instanceof DateCreated).findAny().orElse(null) : null;
                DateUpdated dateUpdated = !CollectionUtils.isEmpty(annotations) ? (DateUpdated)annotations.stream().filter(a -> a instanceof DateUpdated).findAny().orElse(null) : null;
                HashKey hashKey = !CollectionUtils.isEmpty(annotations) ? (HashKey)annotations.stream().filter(a -> a instanceof HashKey).findAny().orElse(null) : null;
                RangeKey rangeKey = !CollectionUtils.isEmpty(annotations) ? (RangeKey)annotations.stream().filter(a -> a instanceof RangeKey).findAny().orElse(null) : null;
                SecondaryIndex gsiElement = !CollectionUtils.isEmpty(annotations) ? (SecondaryIndex)annotations.stream().filter(a -> a instanceof SecondaryIndex).findAny().orElse(null) : null;
                SecondaryIndices gsis = !CollectionUtils.isEmpty(annotations) ? (SecondaryIndices)annotations.stream().filter(a -> a instanceof SecondaryIndices).findAny().orElse(null) : null;
                VersionAttribute versionAttribute = !CollectionUtils.isEmpty(annotations) ? (VersionAttribute)annotations.stream().filter(a -> a instanceof VersionAttribute).findAny().orElse(null) : null;
                String fieldName = dbAttribute != null && !StringUtils.isEmpty((Object)dbAttribute.value()) ? dbAttribute.value() : field.getName();
                Class<?> fieldClass = field.getType();
                if (versionAttribute != null && fieldClass != Integer.TYPE && fieldClass != Integer.class && fieldClass != Long.class && fieldClass != Long.TYPE) {
                    throw new DbException("VersionedAttribute field can only be of type integer or long");
                }
                if (gsis != null && gsiElement != null) {
                    throw new DbException(MessageFormat.format("Both GSIs and GSI cannot be used for the same field [{0}.{1}]", field.getDeclaringClass(), field.getName()));
                }
                List<SecondaryIndex> list = gsiList = gsis != null ? Arrays.asList(gsis.indices()) : Collections.singletonList(gsiElement);
                if (hashKey != null) {
                    primaryKeyMapping.put(KeyType.HASH_KEY, (Tuple2<String, Field>)Tuple.of((Object)fieldName, (Object)field));
                } else if (rangeKey != null) {
                    primaryKeyMapping.put(KeyType.RANGE_KEY, (Tuple2<String, Field>)Tuple.of((Object)fieldName, (Object)field));
                }
                gsiList.forEach(gsi -> {
                    if (gsi != null) {
                        GSI.Builder gsiBuilder = indexMap.computeIfAbsent(gsi.name(), s -> GSI.builder(gsi.name()).projectionType(gsi.projectionType()));
                        Tuple2 keyTuple = Tuple.of((Object)fieldName, (Object)field);
                        switch (gsi.type()) {
                            case HASH_KEY: {
                                gsiBuilder.hashKeyTuple((Tuple2<String, Field>)keyTuple);
                                break;
                            }
                            case RANGE_KEY: {
                                gsiBuilder.rangeKeyTuple((Tuple2<String, Field>)keyTuple);
                                break;
                            }
                            default: {
                                throw new DbException("Unrecognized key type");
                            }
                        }
                    }
                });
                String fieldNameVal = this.getFieldName(dbAttribute, dateCreated, dateUpdated, field, builder);
                mappedFields.put(fieldNameVal, (Tuple2<Field, DbAttribute>)Tuple.of((Object)field, (Object)dbAttribute));
                if (versionAttribute != null) {
                    versionAttMap.put(fieldNameVal, (Tuple2<Field, DbAttribute>)Tuple.of((Object)field, (Object)dbAttribute));
                }
            } else {
                throw new UtilsException("INCORRECT_MODEL_ANNOTATION", "A field can only have one of the following annotation: [DbAttribute, DateCreated, DateUpdated]");
            }
        }
    }

    private <T> String getFieldName(DbAttribute dbAttribute, DateCreated dateCreated, DateUpdated dateUpdated, Field field, AttributeMapper.Builder<T> builder) {
        String fieldName;
        if (dbAttribute != null && !StringUtils.isEmpty((Object)dbAttribute.value())) {
            fieldName = dbAttribute.value();
        } else if (dateCreated != null) {
            fieldName = dateCreated.value();
            builder.dateCreatedField((Tuple2<String, Field>)Tuple.of((Object)dateCreated.value(), (Object)field));
        } else if (dateUpdated != null) {
            fieldName = dateUpdated.value();
            builder.dateUpdatedField((Tuple2<String, Field>)Tuple.of((Object)dateUpdated.value(), (Object)field));
        } else {
            fieldName = field.getName();
        }
        return fieldName;
    }

    private boolean isTransient(List<Annotation> annotations) {
        return !CollectionUtils.isEmpty(annotations) && annotations.stream().anyMatch(a -> a instanceof Transient);
    }

    private boolean isAnnotatedCorrectly(List<Annotation> annotations) {
        List annotationList = CollectionUtils.isEmpty(annotations) ? annotations.stream().filter(a -> a instanceof DbAttribute || a instanceof DateCreated || a instanceof DateUpdated).collect(Collectors.toList()) : Collections.emptyList();
        return CollectionUtils.isEmpty(annotationList) || annotationList.size() == 1;
    }

    public ConcurrentHashMap<String, AttributeMapper<?>> getAttributeMappingMap() {
        return this.attributeMappingMap;
    }

    static MapperUtils getInstance() {
        return INSTANCE;
    }
}

