/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import io.vavr.Tuple2;
import java.lang.reflect.Field;
import java.util.Objects;
import org.awsutils.dynamodb.annotations.KeyType;
import org.awsutils.dynamodb.annotations.ProjectionType;
import org.awsutils.dynamodb.exceptions.DbException;
import org.awsutils.dynamodb.repositories.GSI;

final class GlobalSecondaryIndexImpl
implements GSI {
    private final String name;
    private final Tuple2<String, Field> hashKeyTuple;
    private final Tuple2<String, Field> rangeKeyTuple;
    private final ProjectionType projectionType;

    private GlobalSecondaryIndexImpl(String name, Tuple2<String, Field> hashKeyTuple, Tuple2<String, Field> rangeKeyTuple, ProjectionType projectionType) {
        this.name = name;
        this.hashKeyTuple = hashKeyTuple;
        this.rangeKeyTuple = rangeKeyTuple;
        this.projectionType = projectionType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tuple2<String, Field> getHashKeyTuple() {
        return this.hashKeyTuple;
    }

    @Override
    public Tuple2<String, Field> getRangeKeyTuple() {
        return this.rangeKeyTuple;
    }

    @Override
    public ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSecondaryIndexImpl that = (GlobalSecondaryIndexImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.hashKeyTuple, that.hashKeyTuple) && Objects.equals(this.rangeKeyTuple, that.rangeKeyTuple) && this.projectionType == that.projectionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hashKeyTuple, this.rangeKeyTuple, this.projectionType});
    }

    public String toString() {
        return "GlobalSecondaryIndex{name='" + this.name + "', primaryKeyTuple=" + String.valueOf(this.hashKeyTuple) + ", sortKeyTuple=" + String.valueOf(this.rangeKeyTuple) + ", projectionType=" + String.valueOf((Object)this.projectionType) + "}";
    }

    private GlobalSecondaryIndexImpl validate() {
        if (this.hashKeyTuple == null) {
            throw new DbException("GSI [" + this.name + "] does not have a hash key defined");
        }
        if (this.rangeKeyTuple != null && ((String)this.rangeKeyTuple._1()).equals(this.hashKeyTuple._1())) {
            throw new DbException("GSI [" + this.name + "] - Both hash key and range key have the same field name");
        }
        return this;
    }

    static GSI.Builder builder(String indexName) {
        return new BuilderImpl(indexName);
    }

    private static final class BuilderImpl
    implements GSI.Builder {
        private final String name;
        private Tuple2<String, Field> hashKeyTuple;
        private Tuple2<String, Field> rangeKeyTuple;
        private ProjectionType projectionType;

        private BuilderImpl(String name) {
            this.name = name;
        }

        @Override
        public GSI.Builder hashKeyTuple(Tuple2<String, Field> hashKeyTuple) {
            if (this.hashKeyTuple != null) {
                throw new DbException("Cannot have multiple " + String.valueOf((Object)KeyType.HASH_KEY) + " for the same index [" + this.name + "]");
            }
            this.hashKeyTuple = hashKeyTuple;
            return this;
        }

        @Override
        public GSI.Builder rangeKeyTuple(Tuple2<String, Field> rangeKeyTuple) {
            if (this.rangeKeyTuple != null) {
                throw new DbException("Cannot have multiple " + String.valueOf((Object)KeyType.RANGE_KEY) + " for the same index [" + this.name + "]");
            }
            this.rangeKeyTuple = rangeKeyTuple;
            return this;
        }

        @Override
        public GSI.Builder projectionType(ProjectionType projectionType) {
            if (this.projectionType != null && this.projectionType != projectionType) {
                throw new DbException("Cannot define different projection types for Hash Key and Range Key [" + this.name + "]");
            }
            this.projectionType = projectionType;
            return this;
        }

        @Override
        public GSI build() {
            return new GlobalSecondaryIndexImpl(this.name, this.hashKeyTuple, this.rangeKeyTuple, this.projectionType == null ? ProjectionType.KEYS_ONLY : this.projectionType).validate();
        }
    }
}

