/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import io.vavr.Tuple2;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.awsutils.dynamodb.annotations.KeyType;
import org.awsutils.dynamodb.repositories.AttributeMapper;
import org.awsutils.dynamodb.repositories.DataMapper;
import org.awsutils.dynamodb.repositories.MapperUtils;

abstract class AbstractDataMapper<T>
implements DataMapper<T> {
    AbstractDataMapper() {
    }

    @Override
    public Class<T> getParameterType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected String getHashKey() {
        KeyType keyType = KeyType.HASH_KEY;
        return this.getPKKey(keyType);
    }

    protected String getRangeKey() {
        KeyType keyType = KeyType.RANGE_KEY;
        return this.getPKKey(keyType);
    }

    private String getPKKey(KeyType keyType) {
        AttributeMapper<?> fieldMapping = MapperUtils.INSTANCE.getAttributeMappingMap().get(this.getParameterType().getName());
        Map<KeyType, Tuple2<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        return ((Field)pkMapping.get((Object)keyType)._2()).getName();
    }
}

