/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.data;

import java.util.Objects;

public final class PrimaryKey {
    private final String hashKeyName;
    private final Object hashKeyValue;
    private final String rangeKeyName;
    private final Object rangeKeyValue;

    private PrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        this.hashKeyName = hashKeyName;
        this.hashKeyValue = hashKeyValue;
        this.rangeKeyName = rangeKeyName;
        this.rangeKeyValue = rangeKeyValue;
    }

    public static Builder builder() {
        return new PrimaryKeyBuilder();
    }

    public static Builder builder(String hashKeyName, Object hashKeyValue) {
        return new PrimaryKeyBuilder().hashKeyName(hashKeyName).hashKeyValue(hashKeyValue);
    }

    public String getHashKeyName() {
        return this.hashKeyName;
    }

    public Object getHashKeyValue() {
        return this.hashKeyValue;
    }

    public String getRangeKeyName() {
        return this.rangeKeyName;
    }

    public Object getRangeKeyValue() {
        return this.rangeKeyValue;
    }

    public Builder toBuilder() {
        return PrimaryKey.builder(this.hashKeyName, this.hashKeyValue).rangeKeyValue(this.hashKeyValue).rangeKeyValue(this.rangeKeyValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryKey that = (PrimaryKey)o;
        return Objects.equals(this.hashKeyName, that.hashKeyName) && Objects.equals(this.hashKeyValue, that.hashKeyValue) && Objects.equals(this.rangeKeyName, that.rangeKeyName) && Objects.equals(this.rangeKeyValue, that.rangeKeyValue);
    }

    public int hashCode() {
        return Objects.hash(this.hashKeyName, this.hashKeyValue, this.rangeKeyName, this.rangeKeyValue);
    }

    public String toString() {
        return "[hashKeyName='" + this.hashKeyName + "', hashKeyValue=" + String.valueOf(this.hashKeyValue) + ", rangeKeyName='" + this.rangeKeyName + "', rangeKeyValue=" + String.valueOf(this.rangeKeyValue) + "]";
    }

    private static class PrimaryKeyBuilder
    implements Builder {
        private String hashKeyName;
        private Object hashKeyValue;
        private String rangeName;
        private Object rangeKeyValue;

        PrimaryKeyBuilder() {
        }

        @Override
        public Builder hashKeyName(String hashKeyName) {
            this.hashKeyName = hashKeyName;
            return this;
        }

        @Override
        public Builder hashKeyValue(Object hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        @Override
        public Builder rangeKeyName(String rangeKeyName) {
            this.rangeName = rangeKeyName;
            return this;
        }

        @Override
        public Builder rangeKeyValue(Object rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        @Override
        public PrimaryKey build() {
            return new PrimaryKey(this.hashKeyName, this.hashKeyValue, this.rangeName, this.rangeKeyValue);
        }

        public String toString() {
            return "PrimaryKeyBuilder{hashKeyName='" + this.hashKeyName + "', hashKeyValue='" + String.valueOf(this.hashKeyValue) + "', rangeName='" + this.rangeName + "', rangeKeyValue='" + String.valueOf(this.rangeKeyValue) + "'}";
        }
    }

    public static interface Builder {
        public Builder hashKeyName(String var1);

        public Builder hashKeyValue(Object var1);

        public Builder rangeKeyName(String var1);

        public Builder rangeKeyValue(Object var1);

        public PrimaryKey build();
    }
}

