/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import com.google.common.collect.ImmutableMap;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awsutils.common.util.Utils;
import org.awsutils.dynamodb.annotations.DbAttribute;
import org.awsutils.dynamodb.annotations.DdbRepository;
import org.awsutils.dynamodb.annotations.ProjectionType;
import org.awsutils.dynamodb.data.Page;
import org.awsutils.dynamodb.data.PrimaryKey;
import org.awsutils.dynamodb.data.UpdateItem;
import org.awsutils.dynamodb.exceptions.DbException;
import org.awsutils.dynamodb.exceptions.OptimisticLockFailureException;
import org.awsutils.dynamodb.repositories.AttributeMapper;
import org.awsutils.dynamodb.repositories.DataMapper;
import org.awsutils.dynamodb.repositories.DataMapperUtils;
import org.awsutils.dynamodb.repositories.DynamoDbRepository;
import org.awsutils.dynamodb.repositories.GSI;
import org.awsutils.dynamodb.repositories.MapperUtils;
import org.awsutils.dynamodb.utils.DbUtils;
import org.awsutils.dynamodb.utils.Expr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

enum BaseRepositoryUtils {
    INSTANCE;

    private final ConcurrentHashMap<String, Class<?>> repoParameterTypeMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    static BaseRepositoryUtils getInstance() {
        return INSTANCE;
    }

    UpdateItemResponse handleUpdateItemException(PrimaryKey primaryKey, String tableName, Throwable e) {
        LOGGER.debug(MessageFormat.format("Record with the following primary key [{0}] exists in table [{1}]", primaryKey, tableName), e);
        if (e instanceof CompletionException && e.getCause() instanceof ConditionalCheckFailedException) {
            throw new OptimisticLockFailureException(e.getCause());
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new DbException("UNKNOWN_ERROR - handleUpdateItemException", e);
    }

    <ENTITY_TYPE> Integer setVersion(ENTITY_TYPE item, Tuple2<Field, DbAttribute> versionedAttribute, UpdateItemRequest.Builder updateItemRequestBuilder) {
        Integer version;
        if (versionedAttribute != null) {
            Number versionNum = (Number)ReflectionUtils.getField((Field)((Field)versionedAttribute._1()), item);
            version = versionNum != null ? versionNum.intValue() + 1 : 0;
            Class<?> versionFieldType = ((Field)versionedAttribute._1()).getType();
            if (versionNum == null) {
                updateItemRequestBuilder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                updateItemRequestBuilder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(versionNum.intValue())).build()).build())));
            }
            if (versionFieldType == Integer.class) {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
            } else {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
            }
        } else {
            version = null;
        }
        return version;
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> batchWriteRequest(Function<DataMapper<ENTITY_TYPE>, Stream<WriteRequest>> dbRequestFunc, Supplier<List<ENTITY_TYPE>> returnItemFunc, DataMapper<ENTITY_TYPE> dataMapper) {
        return this.processBatchWriteRequest(returnItemFunc, (Map<String, List<WriteRequest>>)ImmutableMap.of((Object)dataMapper.tableName(), dbRequestFunc.apply(dataMapper).collect(Collectors.toList())));
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> updateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues, Class<ENTITY_TYPE> parameterType, DataMapper<ENTITY_TYPE> dataMapper, ENTITY_TYPE item) {
        Tuple2<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
        UpdateItemRequest.Builder updateItemRequestBuilder = UpdateItemRequest.builder();
        Map<String, Tuple3> mappedFields = MapperUtils.getInstance().getMappedValues(parameterType.getName()).collect(Collectors.toMap(Tuple3::_1, b -> b));
        Stream<Tuple2> mappedValues = updatedValues.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(primaryKey.getHashKeyName())).filter(entry -> !((String)entry.getKey()).equals(primaryKey.getRangeKeyName())).peek(a -> {
            if (mappedFields.get(a.getKey()) != null) {
                DbUtils.checkForNullFields((DbAttribute)((Tuple3)mappedFields.get(a.getKey()))._3(), a.getValue(), (String)((Tuple3)mappedFields.get(a.getKey()))._1());
            }
        }).map(a -> {
            if (mappedFields.get(a.getKey()) != null) {
                return Tuple.of((Object)((String)a.getKey()), (Object)((AttributeValueUpdate)DbUtils.modelToAttributeUpdateValue((Field)((Tuple3)mappedFields.get(a.getKey()))._2(), a.getValue()).apply(AttributeValueUpdate.builder()).build()));
            }
            return Tuple.of((Object)((String)a.getKey()), (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(String.valueOf(a.getValue())).build()).build()));
        });
        ImmutableMap mappedUpdateValuesTmp = mappedValues.collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        Integer version = this.setVersion(item, versionedAttribute, updateItemRequestBuilder);
        ImmutableMap mappedUpdateValues = versionedAttribute != null ? ImmutableMap.builder().putAll(mappedUpdateValuesTmp).put((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(version)).build()).build())).build() : mappedUpdateValuesTmp;
        return DataMapperUtils.getDynamoDbAsyncClient().updateItem((UpdateItemRequest)updateItemRequestBuilder.tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).attributeUpdates(mappedUpdateValues).returnValues(ReturnValue.ALL_NEW).build()).thenApplyAsync(updateItemResponse -> dataMapper.mapFromAttributeValueToEntity(updateItemResponse.attributes()));
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> findByGlobalSecondaryIndex(String indexName, Object hashKeyValueObj, Object rangeKeyValue, Function<ENTITY_TYPE, PrimaryKey> primaryKeyFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc, Function<List<PrimaryKey>, CompletableFuture<List<ENTITY_TYPE>>> findByPrimaryKeyFunc, Expr filterExpression) {
        if (hashKeyValueObj instanceof String) {
            Class dataClass = dataClassFunc.get();
            if (rangeKeyValue != null && !(rangeKeyValue instanceof String)) {
                throw new DbException("Currently only String types are supported for sortKey Values");
            }
            String hashKeyValue = (String)hashKeyValueObj;
            Tuple2<ProjectionType, CompletableFuture<QueryResponse>> queryResponseTuple = this.getDataFromIndex(indexName, hashKeyValue, rangeKeyValue, dataClass, filterExpression);
            CompletionStage returnedDataFromDb = ((CompletableFuture)((CompletableFuture)queryResponseTuple._2).thenApplyAsync(QueryResponse::items)).thenApplyAsync(list -> list.stream().map(a -> DataMapperUtils.getDataMapper(dataClass).mapFromAttributeValueToEntity((Map<String, AttributeValue>)a)).toList());
            CompletionStage returnData = queryResponseTuple._1() == ProjectionType.ALL ? returnedDataFromDb : ((CompletableFuture)((CompletableFuture)((CompletableFuture)returnedDataFromDb).thenApplyAsync(x -> x.stream().map(primaryKeyFunc).toList())).thenApplyAsync(x -> !CollectionUtils.isEmpty((Collection)x) ? (CompletableFuture)findByPrimaryKeyFunc.apply((List<PrimaryKey>)x) : CompletableFuture.completedFuture(List.of()))).thenCompose(Function.identity());
            return returnData;
        }
        throw new DbException("Currently only String types are supported for hashKey Values");
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> findAll(int pageSize, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        return this.findAll(null, pageSize, dataClassFunc);
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> findAll(Expr expr, int pageSize, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClassFunc.get());
        ScanRequest.Builder scanRequestBuilder = ScanRequest.builder().tableName(dataMapper.tableName()).limit(Integer.valueOf(pageSize));
        if (Objects.nonNull(expr)) {
            Map<String, String> attNameMap = expr.attributeNameMap();
            Map<String, AttributeValue> attValueMap = expr.attributeValueMap();
            scanRequestBuilder.filterExpression(expr.expression());
            if (!CollectionUtils.isEmpty(attNameMap)) {
                scanRequestBuilder.expressionAttributeNames(attNameMap);
            }
            if (!CollectionUtils.isEmpty(attValueMap)) {
                scanRequestBuilder.expressionAttributeValues(attValueMap);
            }
        }
        CompletableFuture scanPublisher = DataMapperUtils.getDynamoDbAsyncClient().scan((ScanRequest)scanRequestBuilder.build());
        return ((CompletableFuture)scanPublisher.thenApplyAsync(ScanResponse::items)).thenApplyAsync(x -> x.stream().map(dataMapper::mapFromAttributeValueToEntity).toList());
    }

    <ENTITY_TYPE> CompletableFuture<Optional<ENTITY_TYPE>> findByPrimaryKey(PrimaryKey primaryKey, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClassFunc.get());
        GetItemRequest getItemRequest = (GetItemRequest)GetItemRequest.builder().key(dataMapper.getPrimaryKey(primaryKey)).tableName(dataMapper.tableName()).build();
        return ((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().getItem(getItemRequest).thenApplyAsync(itemResponse -> itemResponse.item())).thenApplyAsync(item -> item.isEmpty() ? Optional.of(dataMapper.mapFromAttributeValueToEntity((Map<String, AttributeValue>)item)) : Optional.empty());
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> findByPrimaryKeys(List<PrimaryKey> primaryKeys, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClassFunc.get());
        ArrayList<PrimaryKey> primaryKeysForQuery = new ArrayList<PrimaryKey>(new HashSet<PrimaryKey>(primaryKeys));
        KeysAndAttributes attributes = (KeysAndAttributes)KeysAndAttributes.builder().keys((Collection)primaryKeysForQuery.stream().map(dataMapper::getPrimaryKey).collect(Collectors.toList())).build();
        HashMap<String, KeysAndAttributes> andAttributesMap = new HashMap<String, KeysAndAttributes>();
        andAttributesMap.put(dataMapper.tableName(), attributes);
        BatchGetItemRequest request = (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(andAttributesMap).build();
        return ((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().batchGetItem(request).thenApplyAsync(batchGetItemResponse -> (List)batchGetItemResponse.responses().get(dataMapper.tableName()))).thenApplyAsync(x -> x.stream().map(dataMapper::mapFromAttributeValueToEntity).toList());
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> saveItem(ENTITY_TYPE item, boolean upsert, BiConsumer<ENTITY_TYPE, Map<String, AttributeValue>> ttlAction, DataMapper<ENTITY_TYPE> dataMapper) {
        PrimaryKey primaryKey = dataMapper.createPKFromItem(item);
        String tableName = dataMapper.tableName();
        Tuple2<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
        String rangeKeyName = primaryKey.getRangeKeyName();
        PutItemRequest.Builder builder = PutItemRequest.builder().tableName(dataMapper.tableName());
        if (!upsert) {
            if (versionedAttribute != null) {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)BigInteger.ZERO.intValue());
            }
            if (!StringUtils.isEmpty((Object)rangeKeyName)) {
                builder.expected((Map)ImmutableMap.of((Object)primaryKey.getHashKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build()), (Object)primaryKey.getRangeKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                builder.expected((Map)ImmutableMap.of((Object)primaryKey.getHashKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            }
        } else if (versionedAttribute != null) {
            int version;
            Number versionNum = (Number)ReflectionUtils.getField((Field)((Field)versionedAttribute._1()), item);
            if (versionNum == null) {
                version = BigInteger.ZERO.intValue();
                builder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                version = versionNum.intValue() + 1;
                builder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().n(String.valueOf(versionNum)).build()}).build())));
            }
            ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
        }
        Map<String, AttributeValue> attributeValues = dataMapper.mapFromEntityToAttributeValue(item);
        ttlAction.accept(item, attributeValues);
        builder.item(attributeValues);
        PutItemRequest putItemRequest = (PutItemRequest)builder.build();
        return ((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().putItem(putItemRequest).thenApplyAsync(putItemResponse -> item)).exceptionally(e -> this.handleCreateItemException(primaryKey, tableName, (Throwable)e));
    }

    <ENTITY_TYPE> ENTITY_TYPE handleCreateItemException(PrimaryKey primaryKey, String tableName, Throwable e) {
        LOGGER.error(MessageFormat.format("Record with the following primary key [{0}] exists in table [{1}]", primaryKey, tableName), e);
        if (e instanceof CompletionException && e.getCause() instanceof ConditionalCheckFailedException) {
            throw new DbException("RECORD_ALREADY_EXISTS", e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new DbException("UNKNOWN_ERROR - handleCreateItemException", e);
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> updateItem(ENTITY_TYPE item, Function<ENTITY_TYPE, PrimaryKey> primaryKeyFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        PrimaryKey primaryKey = primaryKeyFunc.apply(item);
        Class<ENTITY_TYPE> dataClass = dataClassFunc.get();
        DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClass);
        Tuple2<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
        UpdateItemRequest.Builder updateItemRequestBuilder = UpdateItemRequest.builder();
        this.setVersion(item, versionedAttribute, updateItemRequestBuilder);
        Stream<Tuple2> mappedValues = MapperUtils.getInstance().getMappedValues(item, dataClass).peek(a -> DbUtils.checkForNullFields((DbAttribute)a._4(), a._2(), (String)a._1())).filter(a -> a._1() != null).map(a -> Tuple.of((Object)((String)a._1()), (Object)((AttributeValueUpdate)DbUtils.modelToAttributeUpdateValue((Field)a._3(), a._2()).apply(AttributeValueUpdate.builder()).build())));
        return ((CompletableFuture)((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().updateItem((UpdateItemRequest)updateItemRequestBuilder.tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).attributeUpdates(mappedValues.collect(Collectors.toMap(Tuple2::_1, Tuple2::_2))).returnValues(ReturnValue.ALL_NEW).build()).exceptionally(e -> this.handleUpdateItemException(primaryKey, dataMapper.tableName(), (Throwable)e))).thenApplyAsync(updateItemResponse -> dataMapper.mapFromAttributeValueToEntity(updateItemResponse.attributes()))).exceptionallyAsync(throwable -> {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new DbException((Throwable)throwable);
        });
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> updateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues, Function<PrimaryKey, CompletableFuture<ENTITY_TYPE>> findByPrimaryFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        CompletableFuture<ENTITY_TYPE> itemMono = findByPrimaryFunc.apply(primaryKey);
        Class parameterType = dataClassFunc.get();
        DataMapper dataMapper = DataMapperUtils.getDataMapper(parameterType);
        return ((CompletableFuture)itemMono.thenApplyAsync(item -> this.updateItem(primaryKey, updatedValues, parameterType, dataMapper, item))).thenCompose(Function.identity());
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> updateItem(List<UpdateItem> updateItems, Supplier<Class<ENTITY_TYPE>> paramTypeFunc, Function<List<PrimaryKey>, CompletableFuture<List<ENTITY_TYPE>>> findByPrimaryKeysFunc) {
        Class parameterType = paramTypeFunc.get();
        DataMapper dataMapper = DataMapperUtils.getDataMapper(parameterType);
        CompletableFuture<List<ENTITY_TYPE>> items = findByPrimaryKeysFunc.apply(updateItems.stream().map(UpdateItem::getPrimaryKey).collect(Collectors.toList()));
        Map<PrimaryKey, UpdateItem> updateItemMap = updateItems.stream().collect(Collectors.toMap(UpdateItem::getPrimaryKey, b -> b));
        CompletionStage updatedItemsFutureList = items.thenApplyAsync(x -> x.stream().map(item -> this.updateItem(dataMapper.createPKFromItem(item), ((UpdateItem)updateItemMap.get(dataMapper.createPKFromItem(item))).getUpdatedValues(), parameterType, dataMapper, item)).toList());
        return ((CompletableFuture)((CompletableFuture)updatedItemsFutureList).thenApplyAsync(futureList -> CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).thenApply(v -> futureList.stream().map(CompletableFuture::join).toList()))).thenCompose(Function.identity());
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> batchWrite(List<ENTITY_TYPE> putItems, List<ENTITY_TYPE> deleteItems, Supplier<Class<ENTITY_TYPE>> paramTypeFunc) {
        Function<DataMapper, Stream> putFunc = dataMapper -> putItems.stream().map(item -> (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(dataMapper.mapFromEntityToAttributeValue(item)).build()).build());
        Function<DataMapper, Stream> deleteFunc = dataMapper -> (deleteItems != null ? deleteItems : Collections.emptyList()).stream().map(item -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(dataMapper.getPrimaryKey(dataMapper.createPKFromItem(item))).build()).build());
        Function<DataMapper, Stream> dbRequestFunc = dataMapper -> Stream.concat((Stream)putFunc.apply((DataMapper)dataMapper), (Stream)deleteFunc.apply((DataMapper)dataMapper));
        DataMapper<ENTITY_TYPE> dataMapper2 = DataMapperUtils.getDataMapper(paramTypeFunc.get());
        return this.processBatchWriteRequest(() -> putItems, (Map<String, List<WriteRequest>>)ImmutableMap.of((Object)dataMapper2.tableName(), dbRequestFunc.apply(dataMapper2).collect(Collectors.toList())));
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> processBatchWriteRequest(Supplier<List<ENTITY_TYPE>> returnItemFunc, Map<String, List<WriteRequest>> requestItems) {
        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().returnConsumedCapacity(ReturnConsumedCapacity.TOTAL).returnItemCollectionMetrics(ReturnItemCollectionMetrics.SIZE).requestItems(requestItems).build();
        CompletableFuture response = DataMapperUtils.getDynamoDbAsyncClient().batchWriteItem(batchWriteItemRequest);
        return ((CompletableFuture)response.thenApplyAsync(res -> res.hasUnprocessedItems() && !CollectionUtils.isEmpty((Map)res.unprocessedItems()) ? this.processBatchWriteRequest(returnItemFunc, res.unprocessedItems()) : CompletableFuture.completedFuture((List)returnItemFunc.get()))).thenCompose(Function.identity());
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> deleteItem(ENTITY_TYPE item, Supplier<Class<ENTITY_TYPE>> paramTypeFunc) {
        DataMapper<ENTITY_TYPE> dataMapper = DataMapperUtils.getDataMapper(paramTypeFunc.get());
        PrimaryKey primaryKey = dataMapper.createPKFromItem(item);
        DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).build();
        return DataMapperUtils.getDynamoDbAsyncClient().deleteItem(deleteRequest).thenApplyAsync(deleteItemResponse -> item);
    }

    <ENTITY_TYPE> Tuple2<ProjectionType, CompletableFuture<QueryResponse>> getDataFromIndex(String indexName, String hashKeyValue, Object rangeKeyValue, Class<ENTITY_TYPE> dataClass, Expr filterExpressions) {
        AttributeMapper<?> attributeMapper = MapperUtils.getInstance().getAttributeMappingMap().get(dataClass.getName());
        GSI secondaryIndex = attributeMapper.getGlobalSecondaryIndexMap().get(indexName);
        if (secondaryIndex == null) {
            throw new DbException(MessageFormat.format("Index [{0}] not defined in the data model", indexName));
        }
        if (rangeKeyValue != null && secondaryIndex.getRangeKeyTuple() == null) {
            throw new DbException(MessageFormat.format("Sort Key not defined for index[{0}] in the data model", indexName));
        }
        String keyConditionExpression = "#d = :partition_key" + (String)(rangeKeyValue != null ? " and " + (String)secondaryIndex.getRangeKeyTuple()._1() + " = :sort_key_val" : "");
        QueryRequest.Builder builder = QueryRequest.builder();
        HashMap<String, String> nameMap = new HashMap<String, String>(Map.of("#d", (String)secondaryIndex.getHashKeyTuple()._1()));
        HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
        if (rangeKeyValue != null) {
            attributeValueMap.put(":sort_key_val", (AttributeValue)AttributeValue.builder().s(String.valueOf(rangeKeyValue)).build());
        }
        attributeValueMap.put(":partition_key", (AttributeValue)AttributeValue.builder().s(hashKeyValue).build());
        builder.tableName(attributeMapper.getTableName());
        builder.indexName(secondaryIndex.getName());
        this.setFilterExpression(filterExpressions, builder, nameMap, attributeValueMap);
        builder.keyConditionExpression(keyConditionExpression);
        builder.expressionAttributeNames(nameMap);
        builder.expressionAttributeValues(attributeValueMap);
        QueryRequest request = (QueryRequest)builder.build();
        CompletableFuture queryPublisher = DataMapperUtils.getDynamoDbAsyncClient().query(request);
        return Tuple.of((Object)((Object)secondaryIndex.getProjectionType()), (Object)queryPublisher);
    }

    void setFilterExpression(Expr expr, QueryRequest.Builder builder, Map<String, String> nameMap, Map<String, AttributeValue> attributeValueMap) {
        if (expr != null) {
            Map<String, String> attNameMap = expr.attributeNameMap();
            Map<String, AttributeValue> attValueMap = expr.attributeValueMap();
            builder.filterExpression(expr.expression());
            if (!CollectionUtils.isEmpty(attNameMap)) {
                nameMap.putAll(attNameMap);
            }
            if (!CollectionUtils.isEmpty(attValueMap)) {
                attributeValueMap.putAll(attValueMap);
            }
        }
    }

    <ENTITY_TYPE> Class<ENTITY_TYPE> getRepoParameterType(DynamoDbRepository<ENTITY_TYPE> baseRepository) {
        return this.repoParameterTypeMap.computeIfAbsent(baseRepository.getClass().getName(), s -> {
            DdbRepository annotation = baseRepository.getClass().getAnnotation(DdbRepository.class);
            if (annotation != null) {
                return annotation.entityClass();
            }
            throw new DbException("Annotation not defined in Repository implementation.");
        });
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> findByHashKeyAndRangeKeyStartsWithPagination(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, Page page, @Nullable String indexName, Class<ENTITY_TYPE> dataClass, @Nullable Expr expr) {
        if (hashKeyValueObj instanceof String || hashKeyValueObj instanceof Number) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
            String hashAlias = "#a";
            QueryRequest.Builder builder = QueryRequest.builder();
            DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClass);
            Object keyConditionExpression = !StringUtils.isEmpty((Object)rangeKey) && !StringUtils.isEmpty((Object)rangeKeyValue) ? MessageFormat.format("{0} = :{1} and begins_with({2}, :sortKeyVal)", "#a", hashKey, rangeKey) : "#a = :" + hashKey;
            nameMap.put("#a", hashKey);
            if (hashKeyValueObj instanceof String) {
                attributeValueMap.put(MessageFormat.format(":{0}", hashKey), (AttributeValue)AttributeValue.builder().s((String)hashKeyValueObj).build());
            } else {
                attributeValueMap.put(MessageFormat.format(":{0}", hashKey), (AttributeValue)AttributeValue.builder().n(Utils.getUnformattedNumber((Number)((Number)hashKeyValueObj))).build());
            }
            if (!StringUtils.isEmpty((Object)rangeKey) && !StringUtils.isEmpty((Object)rangeKeyValue)) {
                attributeValueMap.put(":sortKeyVal", (AttributeValue)AttributeValue.builder().s(rangeKeyValue).build());
            }
            if (!StringUtils.isEmpty((Object)indexName)) {
                builder.indexName(indexName);
            }
            this.setFilterExpression(expr, builder, nameMap, attributeValueMap);
            if (page != null) {
                builder.limit(Integer.valueOf(page.getPageSize()));
                if (page.getLastEndKey() != null) {
                    String lastEndKeyVal = (String)page.getLastEndKey().getRangeKeyValue();
                    if (StringUtils.isEmpty((Object)rangeKeyValue) || lastEndKeyVal.startsWith(rangeKeyValue)) {
                        builder.exclusiveStartKey(dataMapper.getPrimaryKey(page.getLastEndKey()));
                    } else {
                        throw new DbException("INVALID_RANGE_KEY_VALUE");
                    }
                }
            }
            QueryRequest request = (QueryRequest)builder.tableName(dataMapper.tableName()).keyConditionExpression((String)keyConditionExpression).expressionAttributeNames(nameMap).expressionAttributeValues(attributeValueMap).build();
            CompletableFuture queryResponse = DataMapperUtils.getDynamoDbAsyncClient().query(request);
            return ((CompletableFuture)queryResponse.thenApplyAsync(QueryResponse::items)).thenApplyAsync(list -> list.stream().map(dataMapper::mapFromAttributeValueToEntity).toList());
        }
        throw new DbException("Currently only String/Number types are supported for hashKey Values");
    }

    static {
        LOGGER = LoggerFactory.getLogger(BaseRepositoryUtils.class);
    }
}

