/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.awsutils.common.config.AwsEnvironmentProperties;
import org.awsutils.dynamodb.config.DynamoDbProperties;
import org.awsutils.dynamodb.config.EntityValidationConfig;
import org.awsutils.dynamodb.repositories.DataMapper;
import org.awsutils.dynamodb.repositories.DataMapperConfig;
import org.awsutils.dynamodb.repositories.DataMapperConfigCleanUp;
import org.awsutils.dynamodb.repositories.DynamoDbRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@Configuration
@ConditionalOnClass(value={DynamoDbRepository.class})
@EnableConfigurationProperties(value={DynamoDbProperties.class, AwsEnvironmentProperties.class})
@Import(value={DataMapperConfig.class})
public class DynamoDbAutoConfiguration {
    @Bean(name={"dynamoDbAsyncClientBuilder"})
    @ConditionalOnBean(value={SdkAsyncHttpClient.class})
    public DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder(SdkAsyncHttpClient selectedSdkAsyncHttpClient, AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbAsyncClientBuilder builder = (DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()))).httpClient(selectedSdkAsyncHttpClient);
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbAsyncClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(name={"dynamoDbClientBuilder"})
    @ConditionalOnBean(value={SdkHttpClient.class})
    public DynamoDbClientBuilder dynamoDbClientBuilder(SdkHttpClient selectedSdkHttpClient, AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbClientBuilder builder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()))).httpClient(selectedSdkHttpClient);
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(name={"dynamoDbAsyncClientBuilder"})
    @ConditionalOnMissingBean(value={SdkAsyncHttpClient.class})
    public DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder2(AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbAsyncClientBuilder builder = (DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()));
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbAsyncClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(name={"dynamoDbClientBuilder"})
    @ConditionalOnMissingBean(value={SdkHttpClient.class})
    public DynamoDbClientBuilder dynamoDbClientBuilder2(AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbClientBuilder builder = (DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()));
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDB(AwsCredentialsProvider staticCredentialsProvider, DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)dynamoDbAsyncClientBuilder.credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDBEnv(DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbAsyncClient)dynamoDbAsyncClientBuilder.build();
    }

    @Bean
    @ConditionalOnBean(value={DynamoDbAsyncClient.class})
    public DynamoDbEnhancedAsyncClient dynamoDbEnhancedAsyncClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return DynamoDbEnhancedAsyncClient.builder().dynamoDbClient(dynamoDbAsyncClient).build();
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbClient amazonDynamoSyncDB(AwsCredentialsProvider staticCredentialsProvider, DynamoDbClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbClient)((DynamoDbClientBuilder)dynamoDbAsyncClientBuilder.credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbClient amazonDynamoSyncDBEnv(DynamoDbClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbClient)dynamoDbAsyncClientBuilder.build();
    }

    @Bean
    @ConditionalOnBean(value={DynamoDbClient.class})
    public DynamoDbEnhancedClient dynamoDbEnhancedClient(DynamoDbClient dynamoDbClient) {
        return DynamoDbEnhancedClient.builder().dynamoDbClient(dynamoDbClient).build();
    }

    @Bean(name={"entityValidationConfigMain"})
    @ConditionalOnProperty(prefix="org.awsutils.aws.ddb", value={"entity-base-package"})
    public EntityValidationConfig entityValidationConfigMain(DynamoDbProperties dynamoDbProperties) {
        return new EntityValidationConfig(dynamoDbProperties.getEntityBasePackage());
    }

    @Bean(name={"dataMapperConfigCleanUpMain"})
    @ConditionalOnProperty(prefix="org.awsutils.aws.ddb", value={"entity-base-package"})
    public DataMapperConfigCleanUp dataMapperConfigCleanUpMain(DynamoDbProperties dynamoDbProperties, Map<Class, DataMapper> dataMapperMap, Environment environment) {
        return new DataMapperConfigCleanUp(dynamoDbProperties.getEntityBasePackage(), dataMapperMap, environment);
    }
}

