/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.repositories;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.awsutils.common.config.AwsEnvironmentProperties;
import org.awsutils.dynamodb.config.DynamoDbProperties;
import org.awsutils.dynamodb.config.EntityValidationConfig;
import org.awsutils.dynamodb.repositories.DataMapper;
import org.awsutils.dynamodb.repositories.DataMapperConfig;
import org.awsutils.dynamodb.repositories.DataMapperConfigCleanUp;
import org.awsutils.dynamodb.repositories.DynamoDbRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;

@Configuration
@ConditionalOnClass(value={DynamoDbRepository.class})
@EnableConfigurationProperties(value={DynamoDbProperties.class, AwsEnvironmentProperties.class})
@Import(value={DataMapperConfig.class})
public class DynamoDbAutoConfiguration {
    @Bean(name={"dynamoDbAsyncClientBuilder"})
    @ConditionalOnBean(value={SdkAsyncHttpClient.class})
    public DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder(SdkAsyncHttpClient selectedSdkAsyncHttpClient, AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbAsyncClientBuilder builder = (DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()))).httpClient(selectedSdkAsyncHttpClient);
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbAsyncClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(name={"dynamoDbAsyncClientBuilder"})
    @ConditionalOnMissingBean(value={SdkAsyncHttpClient.class})
    public DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder2(AwsEnvironmentProperties awsEnvironmentProperties) throws URISyntaxException {
        DynamoDbAsyncClientBuilder builder = (DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)awsEnvironmentProperties.getRegion()));
        if (awsEnvironmentProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)awsEnvironmentProperties.getLocalAwsEndpoint())) {
            return (DynamoDbAsyncClientBuilder)builder.endpointOverride(new URI(awsEnvironmentProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDB(AwsCredentialsProvider staticCredentialsProvider, DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)dynamoDbAsyncClientBuilder.credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDBEnv(DynamoDbAsyncClientBuilder dynamoDbAsyncClientBuilder) {
        return (DynamoDbAsyncClient)dynamoDbAsyncClientBuilder.build();
    }

    @Bean(name={"entityValidationConfigMain"})
    @ConditionalOnProperty(prefix="org.awsutils.aws.ddb", value={"entity-base-package"})
    public EntityValidationConfig entityValidationConfigMain(DynamoDbProperties dynamoDbProperties) {
        return new EntityValidationConfig(dynamoDbProperties.getEntityBasePackage());
    }

    @Bean(name={"dataMapperConfigCleanUpMain"})
    @ConditionalOnProperty(prefix="org.awsutils.aws.ddb", value={"entity-base-package"})
    public DataMapperConfigCleanUp dataMapperConfigCleanUpMain(DynamoDbProperties dynamoDbProperties, Map<Class, DataMapper> dataMapperMap, Environment environment) {
        return new DataMapperConfigCleanUp(dynamoDbProperties.getEntityBasePackage(), dataMapperMap, environment);
    }
}

