/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.dynamodb.config;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Set;
import org.awsutils.dynamodb.annotations.DDBTable;
import org.awsutils.dynamodb.exceptions.DbException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class EntityValidationConfig {
    private final String dtoBasePackage;

    public EntityValidationConfig(String dtoBasePackage) {
        this.dtoBasePackage = dtoBasePackage;
    }

    @PostConstruct
    public void validateEntities() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)this.dtoBasePackage, (ClassLoader[])new ClassLoader[]{ClasspathHelper.contextClassLoader(), ClasspathHelper.staticClassLoader()})));
        Set entityClasses = reflections.getTypesAnnotatedWith(DDBTable.class);
        entityClasses.forEach(this::validateEntityClass);
    }

    private void validateEntityClass(Class<?> entityClass) {
        try {
            Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
            if (constructor == null) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException e) {
            throw new DbException(MessageFormat.format("Entity [{0}] does not have a default constructor. All entities should have at least one default no-args constructor", entityClass.getName()));
        }
    }
}

