/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.elastic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.avaje.metric.elastic.BulkJsonWriteVisitor;
import org.avaje.metric.elastic.ElasticReporterConfig;
import org.avaje.metric.elastic.TemplateApply;
import org.avaje.metric.report.MetricReporter;
import org.avaje.metric.report.ReportMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticHttpReporter
implements MetricReporter {
    private static final Logger logger = LoggerFactory.getLogger(ElasticHttpReporter.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final DateTimeFormatter todayFormat = new DateTimeFormatterBuilder().appendPattern("yyyy.MM.dd").toFormatter();
    private final File directory;
    private final OkHttpClient client;
    private final String bulkUrl;
    private final ElasticReporterConfig config;

    public ElasticHttpReporter(ElasticReporterConfig config) {
        this.client = this.getClient(config);
        this.config = config;
        this.bulkUrl = config.getUrl() + "/_bulk";
        this.directory = this.checkDirectory(config.getDirectory());
        new TemplateApply(this.client, config.getUrl(), config.getTemplateName()).run();
    }

    private File checkDirectory(String directory) {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to access or create directory [" + directory + "]");
        }
        return dir;
    }

    private OkHttpClient getClient(ElasticReporterConfig config) {
        OkHttpClient client = config.getClient();
        if (client != null) {
            return client;
        }
        return new OkHttpClient.Builder().connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).build();
    }

    public void report(ReportMetrics reportMetrics) {
        if (reportMetrics.getMetrics().isEmpty()) {
            return;
        }
        StringWriter writer = new StringWriter(1000);
        BulkJsonWriteVisitor jsonVisitor = new BulkJsonWriteVisitor(writer, reportMetrics, this.config, this.today());
        try {
            jsonVisitor.write();
        }
        catch (IOException e) {
            logger.error("Failed to write Bulk JSON for metrics", (Throwable)e);
            return;
        }
        String bulkJson = writer.toString();
        if (!bulkJson.isEmpty()) {
            this.sendMetrics(bulkJson, true);
        }
    }

    private void sendMetrics(String bulkMessage, boolean withQueued) {
        String json = bulkMessage;
        if (logger.isTraceEnabled()) {
            logger.trace("Sending:\n{}", (Object)json);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(this.bulkUrl).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.warn("Unsuccessful sending metrics payload to server - {}", (Object)response.body().string());
                this.storeJsonForResend(json);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Bulk Response - {}", (Object)response.body().string());
                }
                if (withQueued) {
                    this.sendQueued();
                }
            }
        }
        catch (UnknownHostException e) {
            logger.info("UnknownHostException trying to sending metrics to server: " + e.getMessage());
            this.storeJsonForResend(json);
        }
        catch (ConnectException | SocketTimeoutException e) {
            logger.info("Connection error sending metrics to server: " + e.getMessage());
            this.storeJsonForResend(json);
        }
        catch (Exception e) {
            logger.warn("Unexpected error sending metrics to server, metrics queued to be sent later", (Throwable)e);
            this.storeJsonForResend(json);
        }
    }

    private void sendQueued() {
        File[] files = this.directory.listFiles(pathname -> pathname.getName().endsWith(".metric"));
        if (files == null) {
            return;
        }
        for (File heldFile : files) {
            try {
                this.sendMetrics(this.readQueuedFile(heldFile), false);
                if (!heldFile.delete()) {
                    logger.error("Sent but unable to deleted queued metrics file, possible duplicate metrics for file:{}", (Object)heldFile);
                    continue;
                }
                logger.info("Sent queued metrics file {}", (Object)heldFile.getName());
            }
            catch (IOException e) {
                logger.warn("Failed to sent queued metrics file " + heldFile.getName(), (Throwable)e);
                return;
            }
        }
    }

    private String readQueuedFile(File heldFile) throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        List<String> lines = Files.readAllLines(heldFile.toPath());
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private String today() {
        return todayFormat.format(LocalDate.now());
    }

    protected void storeJsonForResend(String json) {
        try {
            File out = new File(this.directory, "metrics-" + System.currentTimeMillis() + ".metric");
            FileWriter fw = new FileWriter(out);
            fw.write(json);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            logger.warn("Failed to store metrics file for resending", (Throwable)e);
        }
    }

    public void cleanup() {
    }
}

