/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.elastic;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.avaje.metric.BucketTimedMetric;
import org.avaje.metric.CounterMetric;
import org.avaje.metric.CounterStatistics;
import org.avaje.metric.GaugeDoubleMetric;
import org.avaje.metric.GaugeLongMetric;
import org.avaje.metric.Metric;
import org.avaje.metric.MetricVisitor;
import org.avaje.metric.TimedMetric;
import org.avaje.metric.ValueMetric;
import org.avaje.metric.ValueStatistics;
import org.avaje.metric.elastic.ElasticReporterConfig;
import org.avaje.metric.report.NumFormat;
import org.avaje.metric.report.ReportMetrics;

class BulkJsonWriteVisitor
implements MetricVisitor {
    private final int decimalPlaces;
    private final Writer buffer;
    private final ReportMetrics reportMetrics;
    private final String header;
    private final ElasticReporterConfig config;
    private final Map<String, String> tags;
    private final long epochNow = System.currentTimeMillis();

    BulkJsonWriteVisitor(Writer writer, ReportMetrics metrics, ElasticReporterConfig config, String indexSuffix) {
        this(2, writer, metrics, config, indexSuffix);
    }

    private BulkJsonWriteVisitor(int decimalPlaces, Writer writer, ReportMetrics metrics, ElasticReporterConfig config, String indexSuffix) {
        this.decimalPlaces = decimalPlaces;
        this.buffer = writer;
        this.reportMetrics = metrics;
        this.config = config;
        this.header = this.deriveHeader(config, indexSuffix);
        this.tags = config.getTags();
    }

    void write() throws IOException {
        for (Metric metric : this.reportMetrics.getMetrics()) {
            metric.visit((MetricVisitor)this);
        }
        this.buffer.flush();
    }

    private String deriveHeader(ElasticReporterConfig config, String indexSuffix) {
        return "{\"index\":{\"_type\":\"" + config.getIndexType() + "\",\"_index\":\"" + config.getIndexPrefix() + indexSuffix + "\"}}";
    }

    private void appendBulkHeader() throws IOException {
        this.buffer.append(this.header);
    }

    private void appendTags() throws IOException {
        this.writeHeader(this.config.getTimestampField(), this.reportMetrics.getCollectionTime());
        if (this.tags != null) {
            Set<Map.Entry<String, String>> entries = this.tags.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.writeHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void writeMetricStart(String type, Metric metric) throws IOException {
        this.appendBulkHeader();
        this.buffer.append("\n{");
        this.appendTags();
        this.writeHeader(this.config.getTypeField(), type);
        this.writeHeader(this.config.getNameField(), metric.getName().getSimpleName());
    }

    private void writeMetricEnd() throws IOException {
        this.buffer.append("}\n");
    }

    public void visit(TimedMetric metric) throws IOException {
        long errCount;
        ValueStatistics normStats = metric.getCollectedSuccessStatistics();
        ValueStatistics errorStats = metric.getCollectedErrorStatistics();
        long count = normStats == null ? 0L : normStats.getCount();
        long l = errCount = errorStats == null ? 0L : errorStats.getCount();
        if (count == 0L && errCount == 0L) {
            return;
        }
        this.writeMetricStart("timed", (Metric)metric);
        if (metric.isBucket()) {
            this.writeHeader("bucket", metric.getBucketRange());
        }
        if (count > 0L) {
            this.writeSummary("norm", normStats);
            if (errCount > 0L) {
                this.buffer.append(",");
            }
        }
        if (errCount > 0L) {
            this.writeSummary("error", errorStats);
        }
        this.writeMetricEnd();
    }

    public void visit(BucketTimedMetric metric) throws IOException {
        for (TimedMetric bucket : metric.getBuckets()) {
            this.visit(bucket);
        }
    }

    public void visit(ValueMetric metric) throws IOException {
        this.writeMetricStart("value", (Metric)metric);
        this.writeSummary("norm", metric.getCollectedStatistics());
        this.writeMetricEnd();
    }

    public void visit(CounterMetric metric) throws IOException {
        this.writeMetricStart("counter", (Metric)metric);
        CounterStatistics counterStatistics = metric.getCollectedStatistics();
        this.writeKeyNumber("count", counterStatistics.getCount());
        this.buffer.append(",");
        this.writeKeyNumber("dur", this.getDuration(counterStatistics.getStartTime()));
        this.writeMetricEnd();
    }

    public void visit(GaugeDoubleMetric metric) throws IOException {
        this.writeMetricStart("gauge", (Metric)metric);
        this.writeKeyNumber("val", this.format(metric.getValue()));
        this.writeMetricEnd();
    }

    public void visit(GaugeLongMetric metric) throws IOException {
        this.writeMetricStart("gaugeLong", (Metric)metric);
        this.writeKeyNumber("val", metric.getValue());
        this.writeMetricEnd();
    }

    private void writeSummary(String prefix, ValueStatistics valueStats) throws IOException {
        long count = valueStats == null ? 0L : valueStats.getCount();
        this.writeKey(prefix);
        this.buffer.append("{");
        this.writeKeyNumber("count", count);
        if (count != 0L) {
            this.buffer.append(",");
            this.writeKeyNumber("avg", valueStats.getMean());
            this.buffer.append(",");
            this.writeKeyNumber("max", valueStats.getMax());
            this.buffer.append(",");
            this.writeKeyNumber("sum", valueStats.getTotal());
            this.buffer.append(",");
            this.writeKeyNumber("dur", this.getDuration(valueStats.getStartTime()));
        }
        this.buffer.append("}");
    }

    private String format(double value) {
        return NumFormat.dp((int)this.decimalPlaces, (double)value);
    }

    private void writeKeyNumber(String key, long numberValue) throws IOException {
        this.writeKeyNumber(key, String.valueOf(numberValue));
    }

    private void writeKeyNumber(String key, String numberValue) throws IOException {
        this.writeKey(key);
        this.writeNumberValue(numberValue);
    }

    private void writeHeader(String key, String value) throws IOException {
        this.writeKey(key);
        this.writeValue(value);
        this.buffer.append(",");
    }

    private void writeHeader(String key, long value) throws IOException {
        this.writeKey(key);
        this.buffer.append(String.valueOf(value));
        this.buffer.append(",");
    }

    private void writeKey(String key) throws IOException {
        this.buffer.append("\"");
        this.buffer.append(key);
        this.buffer.append("\":");
    }

    private void writeValue(String val) throws IOException {
        this.buffer.append("\"");
        this.buffer.append(val);
        this.buffer.append("\"");
    }

    private void writeNumberValue(String val) throws IOException {
        this.buffer.append(val);
    }

    private long getDuration(long startTime) {
        return Math.round((this.epochNow - startTime) / 1000L);
    }
}

