/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.elastic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TemplateApply {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger log = LoggerFactory.getLogger(TemplateApply.class);
    private final OkHttpClient client;
    private final String baseUrl;
    private final String templateName;

    TemplateApply(OkHttpClient client, String baseUrl, String templateName) {
        this.client = client;
        this.baseUrl = this.normalise(baseUrl);
        this.templateName = templateName;
    }

    private String normalise(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    boolean run() {
        return this.templateMissing() && this.putTemplate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean putTemplate() {
        String resourceName = "/elastic-template/" + this.templateName + ".json";
        URL resource = this.getClass().getResource(resourceName);
        if (resource == null) {
            log.warn("Could not find template resource {} to apply to ElasticSearch", (Object)resourceName);
            return false;
        }
        try {
            String template = TemplateApply.read(resource.openStream());
            RequestBody body = RequestBody.create((MediaType)JSON, (String)template);
            String url = this.baseUrl + "/_template/" + this.templateName;
            Request request = new Request.Builder().url(url).put(body).build();
            try (Response response = this.client.newCall(request).execute();){
                if (response.code() == 200) {
                    log.info("PUT template:{}", (Object)this.templateName);
                    boolean bl2 = true;
                    return bl2;
                }
                log.warn("failed to PUT template:{} response:{}", (Object)this.templateName, (Object)response.body().string());
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            log.error("Error trying to PUT template:{}", (Object)this.templateName, (Object)e);
            return false;
        }
    }

    private static String read(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean templateMissing() {
        if (this.templateName == null) {
            return false;
        }
        String url = this.baseUrl + "/_template/" + this.templateName;
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.client.newCall(request).execute();){
            boolean bl = response.code() == 404;
            return bl;
        }
        catch (UnknownHostException e) {
            log.warn("UnknownHostException checking for template: {}", (Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            log.error("failed to check if template {} exists in elasticsearch", (Object)this.templateName, (Object)e);
            return false;
        }
    }
}

