/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.elastic;

import java.io.IOException;
import java.io.StringWriter;
import java.net.ConnectException;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.avaje.metric.elastic.BulkJsonWriteVisitor;
import org.avaje.metric.elastic.ElasticReporterConfig;
import org.avaje.metric.elastic.TemplateApply;
import org.avaje.metric.report.MetricReporter;
import org.avaje.metric.report.ReportMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticHttpReporter
implements MetricReporter {
    private static final Logger logger = LoggerFactory.getLogger(ElasticHttpReporter.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final String bulkUrl;
    private final ElasticReporterConfig config;

    public ElasticHttpReporter(ElasticReporterConfig config) {
        this.client = this.getClient(config);
        this.config = config;
        this.bulkUrl = config.getUrl() + "/_bulk";
        new TemplateApply(this.client, config.getUrl(), config.getTemplateName()).run();
    }

    private OkHttpClient getClient(ElasticReporterConfig config) {
        OkHttpClient client = config.getClient();
        if (client != null) {
            return client;
        }
        return new OkHttpClient.Builder().connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).build();
    }

    public void report(ReportMetrics reportMetrics) {
        StringWriter writer = new StringWriter(1000);
        BulkJsonWriteVisitor jsonVisitor = new BulkJsonWriteVisitor(writer, reportMetrics, this.config, this.today());
        try {
            jsonVisitor.write();
        }
        catch (IOException e) {
            logger.error("Failed to write Bulk JSON to send", (Throwable)e);
            return;
        }
        String json = writer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("Sending:\n{}", (Object)json);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(this.bulkUrl).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                logger.warn("Unsuccessful sending metrics payload to server - {}", (Object)response.body().string());
                this.storeJsonForResend(json);
            } else if (logger.isTraceEnabled()) {
                logger.trace("Bulk Response - {}", (Object)response.body().string());
            }
        }
        catch (ConnectException e) {
            logger.info("Connection error sending metrics to server: " + e.getMessage());
            this.storeJsonForResend(json);
        }
        catch (Exception e) {
            logger.error("Unexpected error sending metrics to server", (Throwable)e);
            this.storeJsonForResend(json);
        }
    }

    private String today() {
        return LocalDate.now().toString();
    }

    protected void storeJsonForResend(String json) {
    }

    public void cleanup() {
    }
}

