/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.elastic;

import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class ElasticReporterConfig {
    private String timestampField = "ts";
    private String typeField = "type";
    private String nameField = "name";
    private String indexType = "metric";
    private String indexPrefix = "metric-";
    private String url = "http://localhost:9200";
    private String templateName = "metric-1";
    private int connectTimeout = 10;
    private int readTimeout = 30;
    private int writeTimeout = 30;
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private OkHttpClient client;

    public String getUrl() {
        return this.url;
    }

    public ElasticReporterConfig setUrl(String url) {
        this.url = this.normalise(url);
        return this;
    }

    String normalise(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public ElasticReporterConfig setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public ElasticReporterConfig setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
        return this;
    }

    public ElasticReporterConfig addTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ElasticReporterConfig setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public ElasticReporterConfig setTimestampField(String timestampField) {
        this.timestampField = timestampField;
        return this;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public ElasticReporterConfig setTypeField(String typeField) {
        this.typeField = typeField;
        return this;
    }

    public String getNameField() {
        return this.nameField;
    }

    public ElasticReporterConfig setNameField(String nameField) {
        this.nameField = nameField;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ElasticReporterConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ElasticReporterConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public ElasticReporterConfig setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public ElasticReporterConfig setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }
}

