/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.avaje.metric.CounterMetric;
import org.avaje.metric.GaugeDouble;
import org.avaje.metric.GaugeDoubleMetric;
import org.avaje.metric.GaugeLong;
import org.avaje.metric.GaugeLongMetric;
import org.avaje.metric.JvmMetrics;
import org.avaje.metric.Metric;
import org.avaje.metric.MetricName;
import org.avaje.metric.MetricNameCache;
import org.avaje.metric.RequestTiming;
import org.avaje.metric.RequestTimingManager;
import org.avaje.metric.TimedMetric;
import org.avaje.metric.TimedMetricGroup;
import org.avaje.metric.ValueMetric;
import org.avaje.metric.spi.SpiMetricManager;
import org.avaje.metric.statistics.MetricStatistics;

public class MetricManager {
    private static final SpiMetricManager mgr = MetricManager.initialiseProvider();
    private static final String DEFAULT_PROVIDER = "org.avaje.metric.core.DefaultMetricManager";

    private static SpiMetricManager initialiseProvider() {
        ServiceLoader<SpiMetricManager> loader = ServiceLoader.load(SpiMetricManager.class);
        Iterator<SpiMetricManager> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_PROVIDER);
            return (SpiMetricManager)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Provider org.avaje.metric.core.DefaultMetricManager not found", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Provider org.avaje.metric.core.DefaultMetricManager could not be instantiated: " + e, e);
        }
    }

    public static void reportTiming(RequestTiming requestTiming) {
        mgr.reportTiming(requestTiming);
    }

    public static MetricName name(Class<?> cls, String name) {
        return mgr.name(cls, name);
    }

    public static MetricName name(String name) {
        return mgr.name(name);
    }

    public static MetricNameCache getMetricNameCache(Class<?> cls) {
        return mgr.getMetricNameCache(cls);
    }

    public static MetricNameCache getMetricNameCache(MetricName baseName) {
        return mgr.getMetricNameCache(baseName);
    }

    public static TimedMetric getTimedMetric(MetricName name, int ... bucketRanges) {
        return mgr.getTimedMetric(name, bucketRanges);
    }

    public static TimedMetric getTimedMetric(Class<?> cls, String name, int ... bucketRanges) {
        return MetricManager.getTimedMetric(MetricManager.name(cls, name), bucketRanges);
    }

    public static TimedMetric getTimedMetric(String name, int ... bucketRanges) {
        return MetricManager.getTimedMetric(MetricManager.name(name), bucketRanges);
    }

    public static TimedMetric getTimedMetric(MetricName name) {
        return mgr.getTimedMetric(name);
    }

    public static TimedMetric getTimedMetric(Class<?> cls, String eventName) {
        return MetricManager.getTimedMetric(MetricManager.name(cls, eventName));
    }

    public static TimedMetric getTimedMetric(String name) {
        return MetricManager.getTimedMetric(MetricManager.name(name));
    }

    public static CounterMetric getCounterMetric(MetricName name) {
        return mgr.getCounterMetric(name);
    }

    public static CounterMetric getCounterMetric(String name) {
        return MetricManager.getCounterMetric(MetricManager.name(name));
    }

    public static CounterMetric getCounterMetric(Class<?> cls, String eventName) {
        return MetricManager.getCounterMetric(MetricManager.name(cls, eventName));
    }

    public static ValueMetric getValueMetric(MetricName name) {
        return mgr.getValueMetric(name);
    }

    public static ValueMetric getValueMetric(Class<?> cls, String eventName) {
        return MetricManager.getValueMetric(MetricManager.name(cls, eventName));
    }

    public static ValueMetric getValueMetric(String name) {
        return MetricManager.getValueMetric(MetricManager.name(name));
    }

    public static TimedMetricGroup getTimedMetricGroup(MetricName baseName) {
        return mgr.getTimedMetricGroup(baseName);
    }

    public static TimedMetricGroup getTimedMetricGroup(Class<?> cls) {
        return MetricManager.getTimedMetricGroup(MetricManager.name(cls, ""));
    }

    public static TimedMetricGroup getTimedMetricGroup(String name) {
        return MetricManager.getTimedMetricGroup(MetricName.of(name));
    }

    public static GaugeDoubleMetric register(MetricName name, GaugeDouble gauge) {
        return mgr.register(name, gauge);
    }

    public static GaugeDoubleMetric register(String name, GaugeDouble gauge) {
        return mgr.register(MetricManager.name(name), gauge);
    }

    public static GaugeLongMetric register(MetricName name, GaugeLong gauge) {
        return mgr.register(name, gauge);
    }

    public static GaugeLongMetric register(String name, GaugeLong gauge) {
        return mgr.register(MetricManager.name(name), gauge);
    }

    public static Collection<Metric> getMetrics() {
        return mgr.getMetrics();
    }

    public static Collection<Metric> getJvmMetrics() {
        return mgr.getJvmMetrics();
    }

    public static List<MetricStatistics> collectNonEmptyMetrics() {
        return mgr.collectNonEmptyMetrics();
    }

    public static List<MetricStatistics> collectNonEmptyJvmMetrics() {
        return mgr.collectNonEmptyJvmMetrics();
    }

    public static JvmMetrics jvmMetrics() {
        return mgr;
    }

    public static RequestTimingManager requestTimingManager() {
        return mgr;
    }
}

