/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.cxf;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.avaje.metric.Clock;
import org.avaje.metric.MetricManager;
import org.avaje.metric.MetricName;
import org.avaje.metric.TimedMetricGroup;
import org.avaje.metric.cxf.ResponseTimeMessageInInterceptor;
import org.avaje.metric.cxf.ResponseTimeMessageOutInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class CxfMetricPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = Logger.getLogger(CxfMetricPostProcessor.class.getName());
    protected final TimeUnit rateUnit;

    public CxfMetricPostProcessor() {
        this(TimeUnit.MINUTES);
    }

    public CxfMetricPostProcessor(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isCxfEndpoint(bean)) {
            return bean;
        }
        if (this.isCxfClientProxy(bean)) {
            return bean;
        }
        return bean;
    }

    private boolean isCxfEndpoint(Object bean) {
        if (bean instanceof InterceptorProvider && bean instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)bean;
            Object implementor = endpoint.getImplementor();
            InterceptorProvider prov = (InterceptorProvider)bean;
            MetricName baseName = this.getServiceBaseName(implementor);
            TimedMetricGroup timedMetricGroup = MetricManager.getTimedMetricGroup((MetricName)baseName, (TimeUnit)this.rateUnit, (Clock)Clock.defaultClock());
            ResponseTimeMessageInInterceptor inInterceptor = new ResponseTimeMessageInInterceptor(timedMetricGroup);
            ResponseTimeMessageOutInterceptor outInterceptor = new ResponseTimeMessageOutInterceptor(timedMetricGroup);
            this.registerInterceptors(prov, (Interceptor<? extends Message>)inInterceptor, (Interceptor<? extends Message>)outInterceptor);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Registered CXF Endpoint: " + implementor.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    private MetricName getServiceBaseName(Object implementor) {
        String simpleName = implementor.getClass().getSimpleName();
        int dollarPos = simpleName.indexOf(36);
        if (dollarPos > 0) {
            simpleName = simpleName.substring(0, dollarPos);
        }
        return new MetricName("webservice.server", simpleName, "placeholder");
    }

    private boolean isCxfClientProxy(Object bean) {
        Class<?>[] interfaces;
        Class<?> clazz = bean.getClass();
        for (Class<?> class1 : interfaces = clazz.getInterfaces()) {
            if (!class1.equals(BindingProvider.class)) continue;
            Class<?> webserviceClass = this.determineInterface(clazz);
            this.registerClientInterceptors(bean, webserviceClass);
            return true;
        }
        return false;
    }

    private void registerClientInterceptors(Object bean, Class<?> webserviceClass) {
        String name = webserviceClass == null ? bean.getClass().getSimpleName() : webserviceClass.getSimpleName();
        Client cxfClient = ClientProxy.getClient((Object)bean);
        MetricName baseName = new MetricName("webservice.client", name, "placeholder", null);
        TimedMetricGroup timedMetricGroup = MetricManager.getTimedMetricGroup((MetricName)baseName, (TimeUnit)this.rateUnit, (Clock)Clock.defaultClock());
        ResponseTimeMessageInInterceptor inIntercept = new ResponseTimeMessageInInterceptor(timedMetricGroup);
        ResponseTimeMessageOutInterceptor outIntercept = new ResponseTimeMessageOutInterceptor(timedMetricGroup);
        this.registerInterceptors((InterceptorProvider)cxfClient, (Interceptor<? extends Message>)inIntercept, (Interceptor<? extends Message>)outIntercept);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registered CXF Client: " + name);
        }
    }

    private void registerInterceptors(InterceptorProvider prov, Interceptor<? extends Message> in, Interceptor<? extends Message> out) {
        prov.getInInterceptors().add(in);
        prov.getInFaultInterceptors().add(in);
        prov.getOutInterceptors().add(out);
        prov.getOutFaultInterceptors().add(out);
    }

    private Class<?> determineInterface(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> class1 : interfaces = clazz.getInterfaces()) {
            if (!class1.isAnnotationPresent(WebService.class)) continue;
            return class1;
        }
        return null;
    }
}

