/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.cxf;

import java.util.concurrent.TimeUnit;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.avaje.metric.MetricNameCache;
import org.avaje.metric.cxf.AbstractMessageResponseTimeInterceptor;

public class ResponseTimeMessageOutInterceptor
extends AbstractMessageResponseTimeInterceptor {
    private EndingInterceptor ending = new EndingInterceptor();

    public ResponseTimeMessageOutInterceptor(MetricNameCache webserviceNameCache, TimeUnit rateUnit) {
        super("send", webserviceNameCache, rateUnit);
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response"))) {
            return;
        }
        if (this.isClient(message)) {
            if (ex.isOneWay()) {
                message.getInterceptorChain().add((Interceptor)this.ending);
            }
            this.beginHandlingMessage(ex, message);
        } else {
            this.endHandlingMessage(ex, message);
        }
    }

    public void handleFault(Message message) {
        Exchange ex = message.getExchange();
        if (!ex.isOneWay()) {
            this.endHandlingMessageWithFault(ex, message);
        }
    }

    EndingInterceptor getEndingInterceptor() {
        return this.ending;
    }

    public class EndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public EndingInterceptor() {
            super("prepare-send-ending");
        }

        public void handleMessage(Message message) throws Fault {
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(message.getExchange(), message);
        }

        public void handleFault(Message message) throws Fault {
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(message.getExchange(), message);
        }
    }
}

