/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.cxf;

import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.avaje.metric.Clock;
import org.avaje.metric.MetricManager;
import org.avaje.metric.MetricName;
import org.avaje.metric.MetricNameCache;
import org.avaje.metric.TimedMetric;
import org.avaje.metric.TimedMetricEvent;

public abstract class AbstractMessageResponseTimeInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected final MetricNameCache webserviceNameCache;
    protected final TimeUnit rateUnit;

    protected AbstractMessageResponseTimeInterceptor(String phase, MetricNameCache webserviceNameCache, TimeUnit rateUnit) {
        super(phase);
        this.webserviceNameCache = webserviceNameCache;
        this.rateUnit = rateUnit;
    }

    protected boolean isClient(Message msg) {
        return msg == null ? false : Boolean.TRUE.equals(msg.get((Object)"org.apache.cxf.client"));
    }

    protected void setFault(Message message, Exchange ex) {
        FaultMode mode = (FaultMode)message.get(FaultMode.class);
        if (mode == null) {
            mode = FaultMode.RUNTIME_FAULT;
        }
        ex.put(FaultMode.class, (Object)mode);
    }

    protected void beginHandlingMessage(Exchange ex, Message message) {
        if (message == null || ex == null) {
            return;
        }
        QName opName = (QName)message.getContextualProperty("javax.xml.ws.wsdl.operation");
        MetricName m = this.webserviceNameCache.get(opName.getLocalPart());
        TimedMetric timedMetric = MetricManager.getTimedMetric((MetricName)m, (TimeUnit)this.rateUnit, (Clock)Clock.defaultClock());
        TimedMetricEvent startEvent = timedMetric.startEvent();
        ex.put(TimedMetricEvent.class, (Object)startEvent);
    }

    protected void endHandlingMessageWithFault(Exchange ex, Message message) {
        this.endHandlingMessage(true, ex, message);
    }

    protected void endHandlingMessage(Exchange ex, Message message) {
        this.endHandlingMessage(false, ex, message);
    }

    protected void endHandlingMessage(boolean isFault, Exchange ex, Message message) {
        if (ex == null) {
            return;
        }
        TimedMetricEvent timedMetricEvent = (TimedMetricEvent)ex.get(TimedMetricEvent.class);
        if (timedMetricEvent == null) {
            return;
        }
        if (isFault || this.isFault(ex, message)) {
            timedMetricEvent.endWithError();
        } else {
            timedMetricEvent.endWithSuccess();
        }
    }

    private boolean isFault(Exchange ex, Message message) {
        return message == ex.getInFaultMessage() || message == ex.getOutFaultMessage();
    }
}

