/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metric.cxf;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.avaje.metric.Clock;
import org.avaje.metric.MetricManager;
import org.avaje.metric.MetricName;
import org.avaje.metric.TimedMetricGroup;
import org.avaje.metric.cxf.ResponseTimeMessageInInterceptor;
import org.avaje.metric.cxf.ResponseTimeMessageOutInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class CxfMetricPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = Logger.getLogger(CxfMetricPostProcessor.class.getName());
    protected final TimeUnit rateUnit;

    public CxfMetricPostProcessor() {
        this(TimeUnit.MINUTES);
    }

    public CxfMetricPostProcessor(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isCxfEndpoint(bean)) {
            return bean;
        }
        if (this.isCxfClientProxy(bean)) {
            return bean;
        }
        return bean;
    }

    private boolean isCxfEndpoint(Object bean) {
        if (bean instanceof InterceptorProvider && bean instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)bean;
            Object implementor = endpoint.getImplementor();
            InterceptorProvider prov = (InterceptorProvider)bean;
            MetricName baseName = new MetricName(implementor.getClass(), null);
            TimedMetricGroup timedMetricGroup = MetricManager.getTimedMetricGroup((MetricName)baseName, (TimeUnit)this.rateUnit, (Clock)Clock.defaultClock());
            prov.getInInterceptors().add(new ResponseTimeMessageInInterceptor(timedMetricGroup));
            prov.getOutInterceptors().add(new ResponseTimeMessageOutInterceptor(timedMetricGroup));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Registered CXF Endpoint: " + implementor.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    private boolean isCxfClientProxy(Object bean) {
        Class<?>[] interfaces;
        Class<?> clazz = bean.getClass();
        for (Class<?> class1 : interfaces = clazz.getInterfaces()) {
            if (!class1.equals(BindingProvider.class)) continue;
            Class<?> webserviceClass = this.determineInterface(clazz);
            this.registerCxfInterceptors(bean, webserviceClass);
            return true;
        }
        return false;
    }

    private void registerCxfInterceptors(Object bean, Class<?> webserviceClass) {
        String name = webserviceClass == null ? bean.getClass().getSimpleName() : webserviceClass.getSimpleName();
        Client cxfClient = ClientProxy.getClient((Object)bean);
        MetricName baseName = new MetricName("webservice.client", name, "placeholder", null);
        TimedMetricGroup timedMetricGroup = MetricManager.getTimedMetricGroup((MetricName)baseName, (TimeUnit)this.rateUnit, (Clock)Clock.defaultClock());
        cxfClient.getInInterceptors().add(new ResponseTimeMessageInInterceptor(timedMetricGroup));
        cxfClient.getOutInterceptors().add(new ResponseTimeMessageOutInterceptor(timedMetricGroup));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registered CXF Client: " + name);
        }
    }

    private Class<?> determineInterface(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> class1 : interfaces = clazz.getInterfaces()) {
            if (!class1.isAnnotationPresent(WebService.class)) continue;
            return class1;
        }
        return null;
    }
}

