/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.ignite.config;

import com.avaje.ebean.cache.ServerCacheType;
import java.util.List;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.avaje.ebean.ignite.config.AddL2CacheConfig;
import org.avaje.ebean.ignite.config.ConfigPair;
import org.avaje.ebean.ignite.config.L2Apply;
import org.avaje.ebean.ignite.config.L2CacheConfig;
import org.avaje.ebean.ignite.config.L2CacheMatch;
import org.avaje.ebean.ignite.config.L2Configuration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    private final L2Configuration configuration;
    private final L2CacheConfig baseQuery;
    private final L2CacheConfig baseBean;
    private final L2CacheConfig baseKey;
    private final L2CacheConfig baseManyIds;

    public ConfigManager(L2Configuration configuration) {
        this.configuration = configuration;
        L2CacheConfig base = this.defaultConfig(configuration.getBase());
        this.baseQuery = this.add(base, configuration.getBaseQuery());
        this.baseBean = this.add(base, configuration.getBaseBean());
        this.baseKey = this.add(base, configuration.getBaseKey());
        this.baseManyIds = this.add(base, configuration.getBaseManyIds());
    }

    private L2CacheConfig add(L2CacheConfig base, L2CacheConfig apply) {
        return AddL2CacheConfig.add(base, apply);
    }

    private L2CacheConfig defaultConfig(L2CacheConfig base) {
        return base != null ? base : new L2CacheConfig();
    }

    public ConfigPair getConfig(ServerCacheType type, String key) {
        L2CacheConfig config = this.getBase(type);
        L2Apply apply = this.configuration.getApply();
        if (apply != null) {
            List<L2CacheMatch> match = apply.getMatch();
            for (L2CacheMatch l2CacheMatch : match) {
                if (!this.isMatch(type, key, l2CacheMatch)) continue;
                logger.debug("match for type[{}] key[{}] to config [{}]", new Object[]{type, key, l2CacheMatch});
                config = this.add(config, l2CacheMatch.getConfig());
            }
        }
        return this.createPair(type, config);
    }

    private ConfigPair createPair(ServerCacheType type, L2CacheConfig config) {
        CacheConfiguration main = new CacheConfiguration();
        AddL2CacheConfig.apply(main, config);
        NearCacheConfiguration near = this.getNearCacheConfig(type, config);
        return new ConfigPair(main, near);
    }

    @Nullable
    private NearCacheConfiguration getNearCacheConfig(ServerCacheType type, L2CacheConfig config) {
        if (type.equals((Object)ServerCacheType.QUERY) || config.getNearSize() == null) {
            return null;
        }
        NearCacheConfiguration near = new NearCacheConfiguration();
        near.setNearEvictionPolicy((EvictionPolicy)new LruEvictionPolicy(config.getNearSize().intValue()));
        return near;
    }

    private boolean isMatch(ServerCacheType type, String key, L2CacheMatch l2CacheMatch) {
        switch (type) {
            case QUERY: {
                return this.isMatch(l2CacheMatch.isTypeQuery(), key, l2CacheMatch);
            }
            case BEAN: {
                return this.isMatch(l2CacheMatch.isTypeBean(), key, l2CacheMatch);
            }
            case NATURAL_KEY: {
                return this.isMatch(l2CacheMatch.isTypeKey(), key, l2CacheMatch);
            }
            case COLLECTION_IDS: {
                return this.isMatch(l2CacheMatch.isTypeManyId(), key, l2CacheMatch);
            }
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private boolean isMatch(Boolean typeMatch, String key, L2CacheMatch l2CacheMatch) {
        return this.isTrue(typeMatch) && this.isMatch(key, l2CacheMatch.getMatchClasses());
    }

    private boolean isMatch(String key, String matchClasses) {
        String[] matches = matchClasses.split("[,;]");
        for (int i = 0; i < matches.length; ++i) {
            String matcher = matches[i].trim();
            if (!matcher.contains(".")) {
                matcher = "." + matcher;
                key = key.toLowerCase();
            }
            if (!key.contains(matcher)) continue;
            return true;
        }
        return false;
    }

    private boolean isTrue(Boolean typeBean) {
        return Boolean.TRUE.equals(typeBean);
    }

    private L2CacheConfig getBase(ServerCacheType type) {
        switch (type) {
            case QUERY: {
                return this.baseQuery;
            }
            case BEAN: {
                return this.baseBean;
            }
            case NATURAL_KEY: {
                return this.baseKey;
            }
            case COLLECTION_IDS: {
                return this.baseManyIds;
            }
        }
        throw new IllegalStateException("Invalid type " + type);
    }
}

