/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.ignite;

import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheStatistics;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IgCache
implements ServerCache {
    private static final Logger logger = LoggerFactory.getLogger(IgCache.class);
    private final IgniteCache cache;

    IgCache(IgniteCache cache) {
        this.cache = cache;
    }

    public Object get(Object id) {
        try {
            return this.cache.get(id);
        }
        catch (Exception e) {
            logger.warn("Error calling cache GET. No ignite servers running?", (Throwable)e);
            return null;
        }
    }

    public Object put(Object id, Object value) {
        try {
            this.cache.put(id, value);
        }
        catch (Exception e) {
            logger.warn("Error calling cache PUT. No ignite servers running?", (Throwable)e);
        }
        return null;
    }

    public Object remove(Object id) {
        try {
            this.cache.remove(id);
        }
        catch (Exception e) {
            logger.warn("Error calling cache REMOVE. No ignite servers running?", (Throwable)e);
        }
        return null;
    }

    public void clear() {
        try {
            this.cache.clear();
        }
        catch (Exception e) {
            logger.warn("Error calling cache CLEAR. No ignite servers running?", (Throwable)e);
        }
    }

    public int size() {
        try {
            return this.cache.size(new CachePeekMode[0]);
        }
        catch (Exception e) {
            logger.warn("Error calling cache SIZE. No ignite servers running?", (Throwable)e);
            return 0;
        }
    }

    public int getHitRatio() {
        return 0;
    }

    public ServerCacheStatistics getStatistics(boolean reset) {
        return null;
    }
}

