/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.ignite.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.avaje.ebean.ignite.config.L2Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigXmlReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigXmlReader.class);

    public static L2Configuration read(String resourcePath) {
        InputStream is = ConfigXmlReader.class.getResourceAsStream(resourcePath);
        if (is == null) {
            return new L2Configuration();
        }
        return ConfigXmlReader.read(is);
    }

    public static L2Configuration read(File file) {
        try {
            return ConfigXmlReader.read(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ignite config file", e);
        }
    }

    public static L2Configuration read(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{L2Configuration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            L2Configuration l2Configuration = (L2Configuration)unmarshaller.unmarshal(is);
            return l2Configuration;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("Error while closing configuration", (Throwable)e);
            }
        }
    }
}

