/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.ignite;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCacheType;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.cache.DefaultServerCache;
import java.io.File;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.avaje.ebean.ignite.IgCache;
import org.avaje.ebean.ignite.config.ConfigManager;
import org.avaje.ebean.ignite.config.ConfigPair;
import org.avaje.ebean.ignite.config.ConfigXmlReader;
import org.avaje.ebean.ignite.config.L2Configuration;
import org.avaje.ignite.IgniteConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgCacheFactory
implements ServerCacheFactory {
    private static final Logger queryLogger = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.QUERY");
    private static final Logger logger = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.CACHE");
    private static final String QC_INVALIDATE = "L2QueryCacheInvalidate";
    private final ConcurrentHashMap<String, IgQueryCache> queryCaches;
    private final ConfigManager configManager;
    private final BackgroundExecutor executor;
    private Ignite ignite;
    private IgniteMessaging messaging;

    public IgCacheFactory(ServerConfig serverConfig, BackgroundExecutor executor) {
        this.executor = executor;
        this.queryCaches = new ConcurrentHashMap();
        this.configManager = new ConfigManager(this.readConfiguration());
        IgniteConfiguration configuration = (IgniteConfiguration)serverConfig.getServiceObject("igniteConfiguration");
        if (configuration == null) {
            Properties properties = serverConfig.getProperties();
            configuration = properties != null ? new IgniteConfigBuilder("ignite", properties).build() : new IgniteConfiguration();
        }
        if (configuration.getGridLogger() == null) {
            configuration.setGridLogger((IgniteLogger)new Slf4jLogger(logger));
        }
        logger.debug("Starting Ignite");
        this.ignite = Ignition.start((IgniteConfiguration)configuration);
        this.messaging = this.ignite.message(this.ignite.cluster().forRemotes());
        this.messaging.localListen((Object)QC_INVALIDATE, (IgniteBiPredicate)new QueryCacheInvalidateListener());
    }

    private L2Configuration readConfiguration() {
        String config = System.getProperty("ebeanIgniteConfig");
        if (config != null) {
            File file = new File(config);
            if (!file.exists()) {
                throw new IllegalStateException("ebean ignite configuration not found at " + config);
            }
            return ConfigXmlReader.read(file);
        }
        File file = new File("ebean-ignite-config.xml");
        if (file.exists()) {
            return ConfigXmlReader.read(file);
        }
        return ConfigXmlReader.read("/ebean-ignite-config.xml");
    }

    public ServerCache createCache(ServerCacheType type, String key, ServerCacheOptions options) {
        logger.debug("create cache - type:{} key:{}", (Object)type, (Object)key);
        switch (type) {
            case QUERY: {
                return this.createQueryCache(key, options);
            }
        }
        return this.createNormalCache(type, key);
    }

    private ServerCache createNormalCache(ServerCacheType type, String key) {
        ConfigPair pair = this.configManager.getConfig(type, key);
        pair.setName(this.fullName(type, key));
        IgniteCache cache = pair.hasNearCache() ? this.ignite.getOrCreateCache(pair.getMain(), pair.getNear()) : this.ignite.getOrCreateCache(pair.getMain());
        return new IgCache(cache);
    }

    private String fullName(ServerCacheType type, String key) {
        return type.name() + "-" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache createQueryCache(String key, ServerCacheOptions options) {
        IgCacheFactory igCacheFactory = this;
        synchronized (igCacheFactory) {
            IgQueryCache cache = this.queryCaches.get(key);
            if (cache == null) {
                cache = new IgQueryCache(key, options);
                cache.periodicTrim(this.executor);
                this.queryCaches.put(key, cache);
            }
            return cache;
        }
    }

    private void sendQueryCacheInvalidation(String key) {
        this.messaging.send((Object)QC_INVALIDATE, (Object)key);
    }

    private void queryCacheInvalidate(String key) {
        IgQueryCache queryCache = this.queryCaches.get(key);
        if (queryCache != null) {
            queryCache.invalidate();
        }
    }

    private class IgQueryCache
    extends DefaultServerCache {
        IgQueryCache(String name, ServerCacheOptions options) {
            super(name, options);
        }

        public void clear() {
            super.clear();
            IgCacheFactory.this.sendQueryCacheInvalidation(this.name);
        }

        private void invalidate() {
            queryLogger.debug("   CLEAR {}(*) - cluster invalidate", (Object)this.name);
            super.clear();
        }
    }

    private class QueryCacheInvalidateListener
    implements IgniteBiPredicate<UUID, String> {
        private QueryCacheInvalidateListener() {
        }

        public boolean apply(UUID uuid, String key) {
            IgCacheFactory.this.queryCacheInvalidate(key);
            return true;
        }
    }
}

