/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import com.avaje.ebean.enhance.agent.ClassMeta;
import com.avaje.ebean.enhance.agent.EnhanceConstants;
import com.avaje.ebean.enhance.agent.FieldMeta;
import com.avaje.ebean.enhance.asm.MethodVisitor;
import com.avaje.ebean.enhance.asm.Opcodes;

public class ConstructorAdapter
extends MethodVisitor
implements EnhanceConstants,
Opcodes {
    private final ClassMeta meta;
    private final String className;
    private final String constructorDesc;
    private boolean constructorInitializationDone;
    private ConsumedInit consumedInit;

    public ConstructorAdapter(MethodVisitor mv, ClassMeta meta, String constructorDesc) {
        super(327680, mv);
        this.meta = meta;
        this.className = meta.getClassName();
        this.constructorDesc = constructorDesc;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.isCollectionInit(opcode, owner, name, desc)) {
            this.consumedInit = new ConsumedInit(opcode, owner, name, desc, itf);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            this.addInitialisationIfRequired(opcode, owner, name, desc);
        }
    }

    private boolean isCollectionInit(int opcode, String owner, String name, String desc) {
        if (opcode == 183 && name.equals("<init>") && desc.equals("()V")) {
            if ("java/util/ArrayList".equals(owner) || "java/util/HashSet".equals(owner) || "java/util/LinkedHashSet".equals(owner)) {
                return true;
            }
            if (this.meta.isLog(4)) {
                this.meta.log("... not consuming many owner:" + owner + " name:" + name + " desc:" + desc);
            }
        }
        return false;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode != 181) {
            if (this.meta.isLog(3)) {
                this.meta.log("... visitFieldInsn - " + opcode + " owner:" + owner + ":" + name + ":" + desc);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            this.consumedInit = null;
        } else {
            FieldMeta fieldMeta;
            if (this.consumedInit != null) {
                if (this.meta.isFieldPersistentMany(name)) {
                    if (this.meta.isLog(2)) {
                        this.meta.log("... consumed collection init and PUTFIELD on persistent many:" + name + " from constructor, type:" + this.consumedInit.owner);
                    }
                    this.consumedInit = null;
                    return;
                }
                if (this.meta.isLog(2)) {
                    this.meta.log("... restore collection init on field " + name + " (non persistent field) " + this.consumedInit);
                }
                super.visitMethodInsn(this.consumedInit.opcode, this.consumedInit.owner, this.consumedInit.name, this.consumedInit.desc, this.consumedInit.itf);
                this.consumedInit = null;
            }
            if ((fieldMeta = this.meta.getFieldPersistent(name)) == null || !fieldMeta.isPersistent()) {
                if (this.meta.isLog(3)) {
                    this.meta.log("... visitFieldInsn (in constructor but non-persistent)- " + opcode + " owner:" + owner + ":" + name + ":" + desc);
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            } else {
                String methodName = "_ebean_set_" + name;
                String methodDesc = "(" + desc + ")V";
                if (this.meta.isLog(2)) {
                    this.meta.log("... Constructor PUTFIELD replaced with:" + methodName + methodDesc);
                }
                super.visitMethodInsn(182, this.className, methodName, methodDesc, false);
            }
        }
    }

    public void addInitialisationIfRequired(int opcode, String owner, String name, String desc) {
        if (opcode == 183 && name.equals("<init>") && desc.equals("()V")) {
            if (this.meta.isSuperClassEntity()) {
                if (this.meta.isLog(3)) {
                    this.meta.log("... skipping intercept <init> ... handled by super class... CONSTRUCTOR: owner:" + owner + " " + this.constructorDesc);
                }
            } else if (owner.equals(this.meta.getClassName())) {
                if (this.meta.isLog(3)) {
                    this.meta.log("... skipping intercept <init> ... handled by other constructor... CONSTRUCTOR: owner:" + owner + " " + this.constructorDesc);
                }
            } else if (owner.equals(this.meta.getSuperClassName())) {
                if (this.meta.isLog(2)) {
                    this.meta.log("... adding intercept <init> in CONSTRUCTOR:" + this.constructorDesc + " OWNER/SUPER:" + owner);
                }
                if (this.constructorInitializationDone) {
                    String msg = "Error in Enhancement. Only expecting to add <init> of intercept object once but it is trying to add it twice for " + this.meta.getClassName() + " CONSTRUCTOR:" + this.constructorDesc + " OWNER:" + owner;
                    System.err.println(msg);
                } else {
                    super.visitVarInsn(25, 0);
                    super.visitTypeInsn(187, "com/avaje/ebean/bean/EntityBeanIntercept");
                    super.visitInsn(89);
                    super.visitVarInsn(25, 0);
                    super.visitMethodInsn(183, "com/avaje/ebean/bean/EntityBeanIntercept", "<init>", "(Ljava/lang/Object;)V", false);
                    super.visitFieldInsn(181, this.className, "_ebean_intercept", "Lcom/avaje/ebean/bean/EntityBeanIntercept;");
                    if (this.meta.isLog(8)) {
                        this.meta.log("... constructorInitializationDone " + owner);
                    }
                    this.constructorInitializationDone = true;
                }
            } else if (this.meta.isLog(3)) {
                this.meta.log("... skipping intercept <init> ... incorrect type " + owner);
            }
        }
    }

    static class ConsumedInit {
        int opcode;
        String owner;
        String name;
        String desc;
        boolean itf;

        public ConsumedInit(int opcode, String owner, String name, String desc, boolean itf) {
            this.opcode = opcode;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.itf = itf;
        }

        public String toString() {
            return this.owner + " name:" + this.name + " desc:" + this.desc;
        }
    }
}

