/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import com.avaje.ebean.enhance.agent.AlreadyEnhancedException;
import com.avaje.ebean.enhance.agent.AnnotationInfo;
import com.avaje.ebean.enhance.agent.AnnotationInfoVisitor;
import com.avaje.ebean.enhance.agent.ClassMeta;
import com.avaje.ebean.enhance.agent.EnhanceContext;
import com.avaje.ebean.enhance.agent.ScopeTransAdapter;
import com.avaje.ebean.enhance.asm.AnnotationVisitor;
import com.avaje.ebean.enhance.asm.ClassVisitor;
import com.avaje.ebean.enhance.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassAdapterTransactional
extends ClassVisitor {
    private static final Logger logger = Logger.getLogger(ClassAdapterTransactional.class.getName());
    private final ArrayList<String> transactionalMethods = new ArrayList();
    private final EnhanceContext enhanceContext;
    private final ClassLoader classLoader;
    private ArrayList<ClassMeta> transactionalInterfaces = new ArrayList();
    private AnnotationInfo classAnnotationInfo;
    private String className;

    public ClassAdapterTransactional(ClassVisitor cv, ClassLoader classLoader, EnhanceContext context) {
        super(327680, cv);
        this.classLoader = classLoader;
        this.enhanceContext = context;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    public AnnotationInfo getClassAnnotationInfo() {
        return this.classAnnotationInfo;
    }

    public AnnotationInfo getInterfaceTransactionalInfo(String methodName, String methodDesc) {
        AnnotationInfo interfaceAnnotationInfo = null;
        for (int i = 0; i < this.transactionalInterfaces.size(); ++i) {
            ClassMeta interfaceMeta = this.transactionalInterfaces.get(i);
            AnnotationInfo ai = interfaceMeta.getInterfaceTransactionalInfo(methodName, methodDesc);
            if (ai == null) continue;
            if (interfaceAnnotationInfo != null) {
                String msg = "Error in [" + this.className + "] searching the transactional interfaces [" + this.transactionalInterfaces + "] found more than one match for the transactional method:" + methodName + " " + methodDesc;
                logger.log(Level.SEVERE, msg);
                continue;
            }
            interfaceAnnotationInfo = ai;
            if (!this.isLog(2)) continue;
            this.log("inherit transactional from interface [" + interfaceMeta + "] method[" + methodName + " " + methodDesc + "]");
        }
        return interfaceAnnotationInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        int n = 1 + interfaces.length;
        String[] newInterfaces = new String[n];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaces[i] = interfaces[i];
            if (newInterfaces[i].equals("com/avaje/ebean/bean/EnhancedTransactional")) {
                throw new AlreadyEnhancedException(name);
            }
            ClassMeta interfaceMeta = this.enhanceContext.getInterfaceMeta(newInterfaces[i], this.classLoader);
            if (interfaceMeta == null || !interfaceMeta.isTransactional()) continue;
            this.transactionalInterfaces.add(interfaceMeta);
            if (!this.isLog(6)) continue;
            this.log(" implements tranactional interface " + interfaceMeta.getDescription());
        }
        newInterfaces[newInterfaces.length - 1] = "com/avaje/ebean/bean/EnhancedTransactional";
        super.visit(version, access, name, signature, superName, newInterfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lcom/avaje/ebean/annotation/Transactional;")) {
            this.classAnnotationInfo = new AnnotationInfo(null);
            return new AnnotationInfoVisitor(null, this.classAnnotationInfo, av);
        }
        return av;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>")) {
            return mv;
        }
        return new ScopeTransAdapter(this, mv, access, name, desc);
    }

    @Override
    public void visitEnd() {
        if (this.isLog(2)) {
            this.log("methods:" + this.transactionalMethods);
        }
        super.visitEnd();
    }

    void transactionalMethod(String methodName, String methodDesc, AnnotationInfo annoInfo) {
        this.transactionalMethods.add(methodName);
        if (this.isLog(4)) {
            this.log("method:" + methodName + " " + methodDesc + " transactional " + annoInfo);
        } else if (this.isLog(3)) {
            this.log("method:" + methodName);
        }
    }
}

